/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.IndexFileBuffer;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class RandomAccessFileBuffer
implements IndexFileBuffer {
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_OFFSET_MASK = 4095;
    private static final int PAGE_MASK = -4096;
    private static final int INVALID_PAGE = 1;
    private final File mFile;
    private RandomAccessFile mRandomAccessFile;
    private final int mFileLength;
    private long mFilePointer = 0L;
    private int mCurrentPage = 1;
    private final byte[] mBuffer = new byte[4096];

    RandomAccessFileBuffer(File file) {
        this.mFile = file;
        try {
            this.mRandomAccessFile = new RandomAccessFile(file, "r");
            long fileLength = this.mRandomAccessFile.length();
            if (fileLength > Integer.MAX_VALUE) {
                throw new RuntimeIOException("BAM index file " + this.mFile + " is too large: " + fileLength);
            }
            this.mFileLength = (int)fileLength;
        }
        catch (IOException exc) {
            throw new RuntimeIOException(exc.getMessage(), exc);
        }
    }

    @Override
    public void readBytes(byte[] bytes) {
        int resultOffset = 0;
        int resultLength = bytes.length;
        if (this.mFilePointer + (long)resultLength > (long)this.mFileLength) {
            throw new RuntimeIOException("Attempt to read past end of BAM index file (file is truncated?): " + this.mFile);
        }
        while (resultLength > 0) {
            this.loadPage(this.mFilePointer);
            int pageOffset = (int)this.mFilePointer & 0xFFF;
            int copyLength = Math.min(resultLength, 4096 - pageOffset);
            System.arraycopy(this.mBuffer, pageOffset, bytes, resultOffset, copyLength);
            this.mFilePointer += (long)copyLength;
            resultOffset += copyLength;
            resultLength -= copyLength;
        }
    }

    @Override
    public int readInteger() {
        this.loadPage(this.mFilePointer);
        int pageOffset = (int)this.mFilePointer & 0xFFF;
        this.mFilePointer += 4L;
        return this.mBuffer[pageOffset + 0] & 0xFF | (this.mBuffer[pageOffset + 1] & 0xFF) << 8 | (this.mBuffer[pageOffset + 2] & 0xFF) << 16 | (this.mBuffer[pageOffset + 3] & 0xFF) << 24;
    }

    @Override
    public long readLong() {
        long lower = this.readInteger();
        long upper = this.readInteger();
        return upper << 32 | lower & 0xFFFFFFFFL;
    }

    @Override
    public void skipBytes(int count) {
        this.mFilePointer += (long)count;
    }

    @Override
    public void seek(long position) {
        this.mFilePointer = position;
    }

    @Override
    public long position() {
        return this.mFilePointer;
    }

    @Override
    public void close() {
        this.mFilePointer = 0L;
        this.mCurrentPage = 1;
        if (this.mRandomAccessFile != null) {
            try {
                this.mRandomAccessFile.close();
            }
            catch (IOException exc) {
                throw new RuntimeIOException(exc.getMessage(), exc);
            }
            this.mRandomAccessFile = null;
        }
    }

    private void loadPage(long filePosition) {
        int page = (int)filePosition & 0xFFFFF000;
        if (page == this.mCurrentPage) {
            return;
        }
        try {
            this.mRandomAccessFile.seek(page);
            int readLength = Math.min(this.mFileLength - page, 4096);
            this.mRandomAccessFile.readFully(this.mBuffer, 0, readLength);
            this.mCurrentPage = page;
        }
        catch (IOException exc) {
            throw new RuntimeIOException("Exception reading BAM index file " + this.mFile + ": " + exc.getMessage(), exc);
        }
    }
}

