/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import java.util.Map;

class SSLRandom
implements IRandom {
    static final String SECRET = "jessie.sslprng.secret";
    static final String SEED = "jessie.sslprng.seed";
    private final IMessageDigest md5 = HashFactory.getInstance("MD5");
    private final IMessageDigest sha = HashFactory.getInstance("SHA-1");
    private byte[] secret;
    private byte[] buffer;
    private byte pad;
    private byte[] seed;
    private int idx;

    public void init(Map map) {
        this.secret = (byte[])map.get(SECRET);
        this.seed = (byte[])map.get(SEED);
        if (this.secret == null || this.seed == null) {
            throw new NullPointerException();
        }
        this.pad = (byte)65;
        try {
            this.buffer = this.nextBlock();
        }
        catch (LimitReachedException limitReachedException) {}
    }

    public String name() {
        return "SSLRandom";
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    public byte nextByte() throws LimitReachedException {
        if (this.buffer == null) {
            throw new IllegalStateException();
        }
        if (this.idx >= this.buffer.length) {
            this.buffer = this.nextBlock();
        }
        return this.buffer[this.idx++];
    }

    public void nextBytes(byte[] byArray, int n, int n2) throws LimitReachedException {
        if (this.buffer == null) {
            throw new IllegalStateException();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.idx >= this.buffer.length) {
                this.buffer = this.nextBlock();
            }
            int n4 = Math.min(this.buffer.length - this.idx, n2 - n3);
            System.arraycopy(this.buffer, this.idx, byArray, n + n3, n4);
            n3 += n4;
            this.idx += n4;
        }
    }

    public boolean selfTest() {
        return true;
    }

    public void addRandomByte(byte by) {
    }

    public void addRandomBytes(byte[] byArray) {
        this.addRandomBytes(byArray, 0, byArray.length);
    }

    public void addRandomBytes(byte[] byArray, int n, int n2) {
    }

    private final byte[] nextBlock() throws LimitReachedException {
        int n = this.pad - 65 + 1;
        if (n > 26) {
            throw new LimitReachedException();
        }
        int n2 = 0;
        while (n2 < n) {
            this.sha.update(this.pad);
            ++n2;
        }
        this.sha.update(this.secret, 0, this.secret.length);
        this.sha.update(this.seed, 0, this.seed.length);
        byte[] byArray = this.sha.digest();
        this.md5.update(this.secret, 0, this.secret.length);
        this.md5.update(byArray, 0, byArray.length);
        this.idx = 0;
        this.pad = (byte)(this.pad + 1);
        return this.md5.digest();
    }

    SSLRandom() {
    }
}

