/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.share.sampled.convert;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.AudioFormats;

public abstract class TFormatConversionProvider
extends FormatConversionProvider {
    protected static final AudioFormat.Encoding[] EMPTY_ENCODING_ARRAY = new AudioFormat.Encoding[0];
    protected static final AudioFormat[] EMPTY_FORMAT_ARRAY = new AudioFormat[0];

    public AudioInputStream getAudioInputStream(AudioFormat.Encoding encoding, AudioInputStream audioInputStream) {
        AudioFormat audioFormat = audioInputStream.getFormat();
        AudioFormat audioFormat2 = new AudioFormat(encoding, -1.0f, -1, -1, -1, -1.0f, audioFormat.isBigEndian());
        if (TDebug.TraceAudioConverter) {
            TDebug.out("TFormatConversionProvider.getAudioInputStream(AudioFormat.Encoding, AudioInputStream):");
            TDebug.out("trying to convert to " + audioFormat2);
        }
        return this.getAudioInputStream(audioFormat2, audioInputStream);
    }

    public boolean isConversionSupported(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("class: " + this.getClass().getName());
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + audioFormat2);
            TDebug.out("to: " + audioFormat);
        }
        AudioFormat[] audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), audioFormat2);
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("checking against possible target format: " + audioFormatArray[n]);
            }
            if (audioFormatArray[n] != null && AudioFormats.matches(audioFormatArray[n], audioFormat)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<result=true");
                }
                return true;
            }
            ++n;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return false;
    }

    public AudioFormat getMatchingFormat(AudioFormat audioFormat, AudioFormat audioFormat2) {
        if (TDebug.TraceAudioConverter) {
            TDebug.out(">TFormatConversionProvider.isConversionSupported(AudioFormat, AudioFormat):");
            TDebug.out("class: " + this.getClass().getName());
            TDebug.out("checking if conversion possible");
            TDebug.out("from: " + audioFormat2);
            TDebug.out("to: " + audioFormat);
        }
        AudioFormat[] audioFormatArray = this.getTargetFormats(audioFormat.getEncoding(), audioFormat2);
        int n = 0;
        while (n < audioFormatArray.length) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out("checking against possible target format: " + audioFormatArray[n]);
            }
            if (audioFormatArray[n] != null && AudioFormats.matches(audioFormatArray[n], audioFormat)) {
                if (TDebug.TraceAudioConverter) {
                    TDebug.out("<result=true");
                }
                return audioFormatArray[n];
            }
            ++n;
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out("<result=false");
        }
        return null;
    }
}

