/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.sasl.srp;

import gnu.java.security.util.Util;
import gnu.javax.crypto.key.srp6.SRPAlgorithm;
import gnu.javax.crypto.sasl.NoSuchUserException;
import gnu.javax.crypto.sasl.UserAlreadyExistsException;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.crypto.sasl.srp.SRPRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PasswordFile {
    private static final String USER_FIELD = "user";
    private static final String VERIFIERS_FIELD = "verifier";
    private static final String SALT_FIELD = "salt";
    private static final String CONFIG_FIELD = "config";
    private static String DEFAULT_FILE = System.getProperty("gnu.crypto.sasl.srp.password.file", "/etc/tpasswd");
    private static final HashMap srps;
    private static final BigInteger[] Nsrp;
    private String confName;
    private String pwName;
    private String pw2Name;
    private File configFile;
    private File passwdFile;
    private File passwd2File;
    private long lastmodPasswdFile;
    private long lastmodPasswd2File;
    private HashMap entries;
    private HashMap configurations;

    private static final String nameToID(String string) {
        if ("sha".equalsIgnoreCase(string) || "sha1".equalsIgnoreCase(string) || "sha-160".equalsIgnoreCase(string)) {
            return "0";
        }
        if ("md5".equalsIgnoreCase(string)) {
            return "1";
        }
        if ("ripemd128".equalsIgnoreCase(string)) {
            return "2";
        }
        if ("ripemd160".equalsIgnoreCase(string)) {
            return "3";
        }
        if ("sha-256".equalsIgnoreCase(string)) {
            return "4";
        }
        if ("sha-384".equalsIgnoreCase(string)) {
            return "5";
        }
        if ("sha-512".equalsIgnoreCase(string)) {
            return "6";
        }
        return "0";
    }

    public synchronized boolean containsConfig(String string) throws IOException {
        this.checkCurrent();
        return this.configurations.containsKey(string);
    }

    public synchronized String[] lookupConfig(String string) throws IOException {
        this.checkCurrent();
        String[] stringArray = null;
        if (this.configurations.containsKey(string)) {
            stringArray = (String[])this.configurations.get(string);
        }
        return stringArray;
    }

    public synchronized boolean contains(String string) throws IOException {
        this.checkCurrent();
        return this.entries.containsKey(string);
    }

    public synchronized void add(String string, String string2, byte[] byArray, String string3) throws IOException {
        this.checkCurrent();
        if (this.entries.containsKey(string)) {
            throw new UserAlreadyExistsException(string);
        }
        HashMap hashMap = new HashMap(4);
        hashMap.put(USER_FIELD, string);
        hashMap.put(VERIFIERS_FIELD, this.newVerifiers(string, byArray, string2, string3));
        hashMap.put(SALT_FIELD, Util.toBase64(byArray));
        hashMap.put(CONFIG_FIELD, string3);
        this.entries.put(string, hashMap);
        this.savePasswd();
    }

    public synchronized void changePasswd(String string, String string2) throws IOException {
        byte[] byArray;
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        HashMap hashMap = (HashMap)this.entries.get(string);
        try {
            byArray = Util.fromBase64((String)hashMap.get(SALT_FIELD));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException("Password file corrupt");
        }
        String string3 = (String)hashMap.get(CONFIG_FIELD);
        hashMap.put(VERIFIERS_FIELD, this.newVerifiers(string, byArray, string2, string3));
        this.entries.put(string, hashMap);
        this.savePasswd();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void savePasswd() throws IOException {
        block19: {
            block24: {
                block23: {
                    block17: {
                        var1_1 = new FileOutputStream(this.passwdFile);
                        var2_2 = new FileOutputStream(this.passwd2File);
                        var3_3 = null;
                        var4_4 = null;
                        try {
                            var3_3 = new PrintWriter(var1_1, true);
                            var4_4 = new PrintWriter(var2_2, true);
                            this.writePasswd(var3_3, var4_4);
                            var6_7 = null;
                            if (var3_3 == null) break block17;
                        }
                        catch (Throwable var5_5) {
                            block22: {
                                block20: {
                                    var6_6 = null;
                                    if (var3_3 == null) break block20;
                                    try {
                                        var3_3.flush();
                                        v0 = null;
                                    }
                                    catch (Throwable var7_8) {
                                        v0 = null;
                                    }
                                    var8_12 = v0;
                                    var3_3.close();
                                    throw var5_5;
                                }
                                if (var4_4 == null) break block22;
                                try {
                                    var4_4.flush();
                                    var8_14 = null;
                                    var4_4.close();
                                    ** GOTO lbl-1000
                                }
                                catch (Throwable var7_9) {
                                    var8_13 = null;
                                    var4_4.close();
                                    throw var7_9;
                                }
                            }
                            try lbl-1000:
                            // 2 sources

                            {
                                var1_1.close();
                            }
                            catch (IOException v1) {}
                            try {
                                var2_2.close();
                                throw var5_5;
                            }
                            catch (IOException v2) {}
                            throw var5_5;
                        }
                        try {}
                        catch (Throwable var7_10) {
                            v3 = null;
lbl54:
                            // 2 sources

                            var8_15 = v3;
                            var3_3.close();
                            break block19;
                        }
                        var3_3.flush();
                        v3 = null;
                        ** GOTO lbl54
                    }
                    if (var4_4 == null) break block23;
                    try {}
                    catch (Throwable var7_11) {
                        var8_16 = null;
                        var4_4.close();
                        throw var7_11;
                    }
                    var4_4.flush();
                    var8_17 = null;
                    var4_4.close();
                    break block24;
                }
                try {}
                catch (IOException v4) {}
            }
            var1_1.close();
            try {}
            catch (IOException v5) {}
            var2_2.close();
        }
        this.lastmodPasswdFile = this.passwdFile.lastModified();
        this.lastmodPasswd2File = this.passwd2File.lastModified();
    }

    public synchronized String[] lookup(String string, String string2) throws IOException {
        this.checkCurrent();
        if (!this.entries.containsKey(string)) {
            throw new NoSuchUserException(string);
        }
        HashMap hashMap = (HashMap)this.entries.get(string);
        HashMap hashMap2 = (HashMap)hashMap.get(VERIFIERS_FIELD);
        String string3 = (String)hashMap.get(SALT_FIELD);
        String string4 = (String)hashMap.get(CONFIG_FIELD);
        String string5 = (String)hashMap2.get(PasswordFile.nameToID(string2));
        return new String[]{string5, string3, string4};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final synchronized void readOrCreateConf() throws IOException {
        this.configurations.clear();
        this.configFile = new File(this.confName);
        try {
            var1_1 = new FileInputStream(this.configFile);
            this.readConf(var1_1);
            return;
        }
        catch (FileNotFoundException var2_2) {
            var3_3 = Util.toBase64(Util.trim(new BigInteger("2")));
            var6_4 = 0;
        }
        while (true) {
            if (var6_4 >= PasswordFile.Nsrp.length) {
                var6_5 = null;
                var7_8 = null;
                ** try [egrp 1[TRYBLOCK] [1 : 129->163)] { 
lbl15:
                // 1 sources

                break;
            }
            var4_6 = String.valueOf(var6_4 + 1);
            var5_7 = Util.toBase64(Util.trim(PasswordFile.Nsrp[var6_4]));
            this.configurations.put(var4_6, new String[]{var5_7, var3_3});
            ++var6_4;
        }
        {
            var6_5 = new FileOutputStream(this.configFile);
            var7_8 = new PrintWriter(var6_5, true);
            this.writeConf(var7_8);
        }
lbl26:
        // 1 sources

        catch (Throwable var8_9) {
            var9_10 = null;
            if (var7_8 != null) {
                var7_8.close();
                throw var8_9;
            }
            if (var6_5 == null) throw var8_9;
            var6_5.close();
            throw var8_9;
        }
        {
            var9_11 = null;
            if (var7_8 != null) {
                var7_8.close();
                return;
            }
            if (var6_5 == null) return;
        }
        var6_5.close();
    }

    private final void readConf(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            try {
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SRP password configuration file corrupt");
            }
            this.configurations.put(string4, new String[]{string3, string2});
        }
    }

    private final void writeConf(PrintWriter printWriter) {
        Iterator iterator = this.configurations.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String[] stringArray = (String[])this.configurations.get(string);
            StringBuffer stringBuffer = new StringBuffer(string).append(":").append(stringArray[0]).append(":").append(stringArray[1]);
            printWriter.println(stringBuffer.toString());
        }
    }

    private final HashMap newVerifiers(String string, byte[] byArray, String string2, String string3) throws UnsupportedEncodingException {
        String[] stringArray = (String[])this.configurations.get(string3);
        BigInteger bigInteger = new BigInteger(1, Util.fromBase64(stringArray[0]));
        BigInteger bigInteger2 = new BigInteger(1, Util.fromBase64(stringArray[1]));
        HashMap hashMap = new HashMap(srps.size());
        int n = 0;
        while (n < srps.size()) {
            String string4 = String.valueOf(n);
            SRP sRP = (SRP)srps.get(string4);
            BigInteger bigInteger3 = new BigInteger(1, sRP.computeX(byArray, string, string2));
            BigInteger bigInteger4 = bigInteger2.modPow(bigInteger3, bigInteger);
            String string5 = Util.toBase64(bigInteger4.toByteArray());
            hashMap.put(string4, string5);
            ++n;
        }
        return hashMap;
    }

    private final synchronized void update() throws IOException {
        FileInputStream fileInputStream;
        this.entries.clear();
        this.passwdFile = new File(this.pwName);
        this.lastmodPasswdFile = this.passwdFile.lastModified();
        try {
            fileInputStream = new FileInputStream(this.passwdFile);
            this.readPasswd(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {}
        this.passwd2File = new File(this.pw2Name);
        this.lastmodPasswd2File = this.passwd2File.lastModified();
        try {
            fileInputStream = new FileInputStream(this.passwd2File);
            this.readPasswd2(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    private final void checkCurrent() throws IOException {
        if (this.passwdFile.lastModified() > this.lastmodPasswdFile || this.passwd2File.lastModified() > this.lastmodPasswd2File) {
            this.update();
        }
    }

    private final void readPasswd(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            String string5;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            try {
                string5 = stringTokenizer.nextToken();
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SRP base password file corrupt");
            }
            HashMap hashMap = new HashMap(6);
            hashMap.put("0", string4);
            HashMap hashMap2 = new HashMap(4);
            hashMap2.put(USER_FIELD, string5);
            hashMap2.put(VERIFIERS_FIELD, hashMap);
            hashMap2.put(SALT_FIELD, string3);
            hashMap2.put(CONFIG_FIELD, string2);
            this.entries.put(string5, hashMap2);
        }
    }

    private final void readPasswd2(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            String string3;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            try {
                string4 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IOException("SRP extended password file corrupt");
            }
            HashMap hashMap = (HashMap)this.entries.get(string3);
            if (hashMap == null) continue;
            HashMap hashMap2 = (HashMap)hashMap.get(VERIFIERS_FIELD);
            hashMap2.put(string4, string2);
        }
    }

    private final void writePasswd(PrintWriter printWriter, PrintWriter printWriter2) throws IOException {
        Iterator iterator = this.entries.keySet().iterator();
        while (iterator.hasNext()) {
            HashMap hashMap;
            String string = (String)iterator.next();
            if (!string.equals((hashMap = (HashMap)this.entries.get(string)).get(USER_FIELD))) {
                throw new IOException("Inconsistent SRP password data");
            }
            HashMap hashMap2 = (HashMap)hashMap.get(VERIFIERS_FIELD);
            StringBuffer stringBuffer = new StringBuffer().append(string).append(":").append((String)hashMap2.get("0")).append(":").append((String)hashMap.get(SALT_FIELD)).append(":").append((String)hashMap.get(CONFIG_FIELD));
            printWriter.println(stringBuffer.toString());
            Iterator iterator2 = hashMap2.keySet().iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if ("0".equals(string2)) continue;
                StringBuffer stringBuffer2 = new StringBuffer().append(string2).append(":").append(string).append(":").append((String)hashMap2.get(string2));
                printWriter2.println(stringBuffer2.toString());
            }
        }
    }

    private final /* synthetic */ void this() {
        this.entries = new HashMap();
        this.configurations = new HashMap();
    }

    public PasswordFile() throws IOException {
        this(DEFAULT_FILE);
    }

    public PasswordFile(File file) throws IOException {
        this(file.getAbsolutePath());
    }

    public PasswordFile(String string) throws IOException {
        this(string, string + '2', string + ".conf");
    }

    public PasswordFile(String string, String string2) throws IOException {
        this(string, string + '2', string2);
    }

    public PasswordFile(String string, String string2, String string3) throws IOException {
        this.this();
        this.pwName = string;
        this.pw2Name = string2;
        this.confName = string3;
        this.readOrCreateConf();
        this.update();
    }

    static {
        HashMap hashMap = new HashMap(SRPRegistry.SRP_ALGORITHMS.length);
        hashMap.put("0", SRP.instance(SRPRegistry.SRP_ALGORITHMS[0]));
        int n = 1;
        while (n < SRPRegistry.SRP_ALGORITHMS.length) {
            try {
                hashMap.put(String.valueOf(n), SRP.instance(SRPRegistry.SRP_ALGORITHMS[n]));
            }
            catch (Exception exception) {
                System.err.println("Ignored: " + exception);
                exception.printStackTrace(System.err);
            }
            ++n;
        }
        srps = hashMap;
        Nsrp = new BigInteger[]{SRPAlgorithm.N_2048, SRPAlgorithm.N_1536, SRPAlgorithm.N_1280, SRPAlgorithm.N_1024, SRPAlgorithm.N_768, SRPAlgorithm.N_640, SRPAlgorithm.N_512};
    }
}

