/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;
import org.w3c.dom.traversal.TreeWalker;

public class DomNodeIterator
implements NodeIterator,
TreeWalker {
    Node root;
    final int whatToShow;
    final NodeFilter filter;
    final boolean entityReferenceExpansion;
    final boolean walk;
    Node current;

    public Node getRoot() {
        return this.root;
    }

    public int getWhatToShow() {
        return this.whatToShow;
    }

    public NodeFilter getFilter() {
        return this.filter;
    }

    public boolean getExpandEntityReferences() {
        return this.entityReferenceExpansion;
    }

    public Node nextNode() throws DOMException {
        Node node2;
        if (this.root == null) {
            throw new DOMException(11, "null root");
        }
        do {
            if (this.current.equals(this.root)) {
                node2 = this.root.getFirstChild();
                continue;
            }
            if (this.walk) {
                node2 = this.current.getFirstChild();
                if (node2 == null) {
                    node2 = this.current.getNextSibling();
                }
                if (node2 != null) continue;
                Node node3 = this.current;
                node2 = node3.getParentNode();
                while (!node2.equals(this.root) && node3.equals(node2.getLastChild())) {
                    node3 = node2;
                    node2 = node3.getParentNode();
                }
                if (node2.equals(this.root)) {
                    node2 = null;
                    continue;
                }
                node2 = node2.getNextSibling();
                continue;
            }
            node2 = this.current.getNextSibling();
        } while (!this.accept(node2));
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public Node previousNode() throws DOMException {
        Node node2;
        if (this.root == null) {
            throw new DOMException(11, "null root");
        }
        do {
            if (this.current.equals(this.root)) {
                node2 = this.current.getLastChild();
                continue;
            }
            if (this.walk) {
                node2 = this.current.getLastChild();
                if (node2 == null) {
                    node2 = this.current.getPreviousSibling();
                }
                if (node2 != null) continue;
                Node node3 = this.current;
                node2 = node3.getParentNode();
                while (!node2.equals(this.root) && node3.equals(node2.getFirstChild())) {
                    node3 = node2;
                    node2 = node3.getParentNode();
                }
                if (node2.equals(this.root)) {
                    node2 = null;
                    continue;
                }
                node2 = node2.getPreviousSibling();
                continue;
            }
            node2 = this.current.getPreviousSibling();
        } while (!this.accept(node2));
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public Node getCurrentNode() {
        return this.current;
    }

    public void setCurrentNode(Node node2) throws DOMException {
        if (node2 == null) {
            throw new DOMException(9, "null root");
        }
        this.current = node2;
    }

    public Node parentNode() {
        Node node2 = this.current.getParentNode();
        if (!this.accept(node2)) {
            node2 = null;
        }
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public Node firstChild() {
        Node node2 = this.current.getFirstChild();
        while (!this.accept(node2)) {
            node2 = node2.getNextSibling();
        }
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public Node lastChild() {
        Node node2 = this.current.getLastChild();
        while (!this.accept(node2)) {
            node2 = node2.getPreviousSibling();
        }
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public Node previousSibling() {
        Node node2 = this.current.getPreviousSibling();
        while (!this.accept(node2)) {
            node2 = node2.getPreviousSibling();
        }
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public Node nextSibling() {
        Node node2 = this.current.getNextSibling();
        while (!this.accept(node2)) {
            node2 = node2.getNextSibling();
        }
        this.current = node2 == null ? this.current : node2;
        return node2;
    }

    public void detach() {
        this.root = null;
    }

    boolean accept(Node node2) {
        boolean bl;
        if (node2 == null) {
            return true;
        }
        switch (node2.getNodeType()) {
            case 2: {
                boolean bl2 = false;
                if ((this.whatToShow & 2) != 0) {
                    bl2 = true;
                }
                bl = bl2;
                break;
            }
            case 4: {
                boolean bl3 = false;
                if ((this.whatToShow & 8) != 0) {
                    bl3 = true;
                }
                bl = bl3;
                break;
            }
            case 8: {
                boolean bl4 = false;
                if ((this.whatToShow & 0x80) != 0) {
                    bl4 = true;
                }
                bl = bl4;
                break;
            }
            case 9: {
                boolean bl5 = false;
                if ((this.whatToShow & 0x100) != 0) {
                    bl5 = true;
                }
                bl = bl5;
                break;
            }
            case 11: {
                boolean bl6 = false;
                if ((this.whatToShow & 0x400) != 0) {
                    bl6 = true;
                }
                bl = bl6;
                break;
            }
            case 10: {
                boolean bl7 = false;
                if ((this.whatToShow & 0x200) != 0) {
                    bl7 = true;
                }
                bl = bl7;
                break;
            }
            case 1: {
                boolean bl8 = false;
                if ((this.whatToShow & 1) != 0) {
                    bl8 = true;
                }
                bl = bl8;
                break;
            }
            case 6: {
                boolean bl9 = false;
                if ((this.whatToShow & 0x20) != 0) {
                    bl9 = true;
                }
                bl = bl9;
                break;
            }
            case 5: {
                boolean bl10 = false;
                if ((this.whatToShow & 0x10) != 0) {
                    bl10 = true;
                }
                bl = bl10;
                boolean bl11 = false;
                if (bl && this.entityReferenceExpansion) {
                    bl11 = true;
                }
                bl = bl11;
                break;
            }
            case 12: {
                boolean bl12 = false;
                if ((this.whatToShow & 0x800) != 0) {
                    bl12 = true;
                }
                bl = bl12;
                break;
            }
            case 7: {
                boolean bl13 = false;
                if ((this.whatToShow & 0x40) != 0) {
                    bl13 = true;
                }
                bl = bl13;
                break;
            }
            case 3: {
                boolean bl14 = false;
                if ((this.whatToShow & 4) != 0) {
                    bl14 = true;
                }
                bl = bl14;
                break;
            }
            default: {
                bl = true;
            }
        }
        if (bl && this.filter != null) {
            boolean bl15 = false;
            if (this.filter.acceptNode(node2) == 1) {
                bl15 = true;
            }
            bl = bl15;
        }
        return bl;
    }

    public DomNodeIterator(Node node2, int n, NodeFilter nodeFilter, boolean bl, boolean bl2) {
        if (node2 == null) {
            throw new DOMException(9, "null root");
        }
        this.root = node2;
        this.whatToShow = n;
        this.filter = nodeFilter;
        this.entityReferenceExpansion = bl;
        this.walk = bl2;
        this.current = node2;
    }
}

