require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_CPU_H_)) {
    eval 'sub _CPU_H_ () {1;}' unless defined(&_CPU_H_);
    eval 'sub CPU_BOOTED_KERNEL () {1;}' unless defined(&CPU_BOOTED_KERNEL);
    eval 'sub CPU_BOOTED_DEVICE () {2;}' unless defined(&CPU_BOOTED_DEVICE);
    eval 'sub CPU_BOOT_ARGS () {3;}' unless defined(&CPU_BOOT_ARGS);
    eval 'sub CPU_ARCH () {4;}' unless defined(&CPU_ARCH);
    eval 'sub CPU_VIS () {5;}' unless defined(&CPU_VIS);
    if(defined(&_KERNEL) || defined(&_KMEMUSER)) {
	if(defined(&_KERNEL_OPT)) {
	    require './sparc64/opt_gprof.ph';
	    require './sparc64/opt_multiprocessor.ph';
	    require './sparc64/opt_lockdebug.ph';
	}
	require 'machine/psl.ph';
	require 'machine/reg.ph';
	require 'machine/pte.ph';
	require 'machine/intr.ph';
	if(defined(&_KERNEL)) {
	    require 'machine/bus_defs.ph';
	    require 'machine/cpuset.ph';
	    require 'sparc64/sparc64/intreg.ph';
	}
	if(defined(&SUN4V)) {
	    require 'machine/hypervisor.ph';
	}
	require 'sys/cpu_data.ph';
	require 'sys/mutex.ph';
	require 'sys/evcnt.ph';
	if(defined(&GPROF)  && defined(&MULTIPROCESSOR)) {
	}
    }
    if(defined(&_KERNEL)) {
	eval 'sub CPUF_PRIMARY () {1;}' unless defined(&CPUF_PRIMARY);
	if(defined(&MULTIPROCESSOR)) {
	} else {
	    eval 'sub sparc_ncpus () {1;}' unless defined(&sparc_ncpus);
	}
	eval 'sub CURCPU_INT () {
	    eval q(( &CPUINFO_VA));
	}' unless defined(&CURCPU_INT);
	eval 'sub curcpu () {
	    eval q(( &CURCPU_INT()-> &ci_self));
	}' unless defined(&curcpu);
	eval 'sub cpu_number () {
	    eval q(( &curcpu()-> &ci_index));
	}' unless defined(&cpu_number);
	eval 'sub CPU_IS_PRIMARY {
	    my($ci) = @_;
    	    eval q((($ci)-> &ci_flags &  &CPUF_PRIMARY));
	}' unless defined(&CPU_IS_PRIMARY);
	eval 'sub CPU_INFO_ITERATOR () {\'int\'  &__unused;}' unless defined(&CPU_INFO_ITERATOR);
	eval 'sub CPU_INFO_FOREACH {
	    my($cii, $ci) = @_;
    	    eval q($ci =  &cpus; $ci !=  &NULL; $ci =  ($ci->{ci_next}));
	}' unless defined(&CPU_INFO_FOREACH);
	eval 'sub curlwp () { &CURCPU_INT()-> &ci_curlwp;}' unless defined(&curlwp);
	eval 'sub fplwp () { &CURCPU_INT()-> &ci_fplwp;}' unless defined(&fplwp);
	eval 'sub curpcb () { &CURCPU_INT()-> &ci_cpcb;}' unless defined(&curpcb);
	eval 'sub want_ast () { &CURCPU_INT()-> &ci_want_ast;}' unless defined(&want_ast);
	eval 'sub cpu_wait {
	    my($p) = @_;
    	    eval q();
	}' unless defined(&cpu_wait);
	if(defined(&MULTIPROCESSOR)) {
	}
	eval 'sub LWP_PC {
	    my($l) = @_;
    	    eval q((($l)-> ($l_md->{md_tf}->{tf_pc})));
	}' unless defined(&LWP_PC);
	eval 'sub CLKF_USERMODE {
	    my($framep) = @_;
    	    eval q(((($framep)-> ($t->{tf_tstate}) &  &TSTATE_PRIV) == 0));
	}' unless defined(&CLKF_USERMODE);
	eval 'sub CLKF_PC {
	    my($framep) = @_;
    	    eval q((($framep)-> ($t->{tf_pc})));
	}' unless defined(&CLKF_PC);
	eval 'sub CLKF_INTR {
	    my($framep) = @_;
    	    eval q(((! &CLKF_USERMODE($framep)) && ((($framep)-> ($t->{tf_out[6]}) & 1) ? ((( &vaddr_t)($framep)-> ($t->{tf_out[6]}) < ( &vaddr_t) &EINTSTACK-0x7ff)  && (( &vaddr_t)($framep)-> ($t->{tf_out[6]}) > ( &vaddr_t) &INTSTACK-0x7ff)) : ((( &vaddr_t)($framep)-> ($t->{tf_out[6]}) < ( &vaddr_t) &EINTSTACK)  && (( &vaddr_t)($framep)-> ($t->{tf_out[6]}) > ( &vaddr_t) &INTSTACK)))));
	}' unless defined(&CLKF_INTR);
	eval 'sub cpu_need_proftick {
	    my($l) = @_;
    	    eval q((($l)-> &l_pflag |=  &LP_OWEUPC,  &want_ast = 1));
	}' unless defined(&cpu_need_proftick);
	eval 'sub write_all_windows () {
	    eval q( &__asm  &volatile(\\"flushw\\" : : ));
	}' unless defined(&write_all_windows);
	eval 'sub write_user_windows () {
	    eval q( &__asm  &volatile(\\"flushw\\" : : ));
	}' unless defined(&write_user_windows);
	if(defined(&KGDB)) {
	}
    }
}
1;
