/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.Utilities;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class MultiThreadUtils {
    private MultiThreadUtils() {
    }

    public static <E> void putInBlockingQ(BlockingQueue<E> blockingQueue, E e) {
        try {
            blockingQueue.put(e);
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("ERROR: ", interruptedException);
        }
    }

    public static <E> boolean putInBlockingQ(BlockingQueue<E> blockingQueue, E e, long l, TimeUnit timeUnit) {
        try {
            return blockingQueue.offer(e, l, timeUnit);
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("ERROR: ", interruptedException);
            return false;
        }
    }

    public static <E> E takeFromBlockingQ(BlockingQueue<E> blockingQueue) {
        try {
            return blockingQueue.take();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("ERROR: ", interruptedException);
            assert (false);
            return null;
        }
    }

    public static void await(CountDownLatch countDownLatch) {
        try {
            countDownLatch.await();
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("ERROR", interruptedException);
        }
    }

    public static void shutdownExecService(ExecutorService executorService) {
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (InterruptedException interruptedException) {
            Utilities.exit("ERROR", interruptedException);
        }
    }
}

