/*****
 NAME
	tgraphics.h - type definition for graphic objects
 VERSION
	$Id$
 CHANGELOG
	$Log$
 */

#if !defined(TGRAPHICS_H_INCLUDED)
#define TGRAPHICS_H_INCLUDED

typedef	int	position_t ;
typedef	int	dimension_t ;

typedef enum {
	align_default	= 0,
	align_left	= 1,
	align_top	= 1,
	align_center	= 2,
	align_middle	= 2, 
	align_right	= 3,
	align_bottom	= 3
} align_t ;

/* these color code is copied from ncurses.h */
typedef	enum {
	rgb_black	= 0,
	rgb_red		= 1,
	rgb_green	= 2,
	rgb_yellow	= 3,
	rgb_blue	= 4,
	rgb_magenta	= 5,
	rgb_cyan	= 6,
	rgb_white	= 7
} rgb_t ;

typedef enum {
	style_normal		= 0x00,
	style_hilight		= 0x01,
	style_underline		= 0x02,
	style_reverse		= 0x04,
	style_blink		= 0x08,
	style_bold		= 0x10,
	style_itallic		= 0x20
} style_t ;

#define	OR_STYLE(S1, S2)	((style_t) ((u_int) S1) | ((u_int) S2))
#define	IS_STYLE(VAL, TYPE)	(((u_int) VAL) & ((u_int) TYPE))

#endif /* !defined(TGRAPHICS_H_INCLUDED) */

