/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.aggregate;

import java.util.List;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.TypeResolutions;
import org.elasticsearch.xpack.sql.expression.function.aggregate.EnclosedAgg;
import org.elasticsearch.xpack.sql.expression.function.aggregate.NumericAggregate;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.tree.Source;
import org.elasticsearch.xpack.sql.type.DataType;

public class Min
extends NumericAggregate
implements EnclosedAgg {
    public Min(Source source, Expression field) {
        super(source, field);
    }

    @Override
    protected NodeInfo<Min> info() {
        return NodeInfo.create(this, Min::new, this.field());
    }

    @Override
    public Min replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return new Min(this.source(), newChildren.get(0));
    }

    @Override
    public DataType dataType() {
        return this.field().dataType();
    }

    @Override
    public String innerName() {
        return "min";
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        if (this.field().dataType().isString()) {
            return TypeResolutions.isExact(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
        }
        return TypeResolutions.isNumericOrDate(this.field(), this.sourceText(), Expressions.ParamOrdinal.DEFAULT);
    }
}

