/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

final class CloseFollowerIndexStep
extends AsyncRetryDuringSnapshotActionStep {
    static final String NAME = "close-follower-index";

    CloseFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    void performDuringNoSnapshot(IndexMetaData indexMetaData, ClusterState currentClusterState, AsyncActionStep.Listener listener) {
        String followerIndex = indexMetaData.getIndex().getName();
        Map customIndexMetadata = indexMetaData.getCustomData("ccr");
        if (customIndexMetadata == null) {
            listener.onResponse(true);
            return;
        }
        CloseIndexRequest closeIndexRequest = new CloseIndexRequest(new String[]{followerIndex});
        this.getClient().admin().indices().close(closeIndexRequest, ActionListener.wrap(r -> {
            assert (r.isAcknowledged()) : "close index response is not acknowledged";
            listener.onResponse(true);
        }, listener::onFailure));
    }
}

