/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.IncrementalTaskAction;
import org.gradle.api.internal.project.taskfactory.StandardTaskAction;
import org.gradle.api.internal.project.taskfactory.TaskActionFactory;
import org.gradle.api.internal.project.taskfactory.TaskClassInfo;
import org.gradle.api.internal.project.taskfactory.TaskClassInfoStore;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.work.InputChanges;

@NonNullApi
public class DefaultTaskClassInfoStore
implements TaskClassInfoStore {
    private final CrossBuildInMemoryCache<Class<?>, TaskClassInfo> classInfos;
    private final Function<Class<?>, TaskClassInfo> taskClassInfoFactory = aClass -> this.createTaskClassInfo(aClass.asSubclass(Task.class));

    public DefaultTaskClassInfoStore(CrossBuildInMemoryCacheFactory cacheFactory) {
        this.classInfos = cacheFactory.newClassCache();
    }

    @Override
    public TaskClassInfo getTaskClassInfo(Class<? extends Task> type) {
        return (TaskClassInfo)this.classInfos.get(type, this.taskClassInfoFactory);
    }

    private TaskClassInfo createTaskClassInfo(Class<? extends Task> type) {
        boolean cacheable = type.isAnnotationPresent(CacheableTask.class);
        Optional<String> reasonNotToTrackState = Optional.ofNullable(type.getAnnotation(UntrackedTask.class)).map(UntrackedTask::because);
        HashMap processedMethods = new HashMap();
        ImmutableList.Builder taskActionFactoriesBuilder = ImmutableList.builder();
        IncrementalTaskActionFactory foundIncrementalTaskActionFactory = null;
        for (Class<? extends Task> current = type; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                TaskActionFactory taskActionFactory = DefaultTaskClassInfoStore.createTaskAction(type, method);
                if (taskActionFactory == null) continue;
                Class<?> declaringClass = method.getDeclaringClass();
                Class<?> previousDeclaringClass = processedMethods.put(method.getName(), declaringClass);
                if (taskActionFactory instanceof IncrementalTaskActionFactory && foundIncrementalTaskActionFactory != null && method.getName().equals(foundIncrementalTaskActionFactory.getMethod().getName()) && taskActionFactory.getClass() == foundIncrementalTaskActionFactory.getClass()) continue;
                if (previousDeclaringClass == declaringClass) {
                    throw new GradleException(String.format("Cannot use @TaskAction annotation on multiple overloads of method %s.%s()", declaringClass.getSimpleName(), method.getName()));
                }
                if (previousDeclaringClass != null) continue;
                if (taskActionFactory instanceof IncrementalTaskActionFactory) {
                    if (foundIncrementalTaskActionFactory != null) {
                        throw new GradleException(String.format("Cannot have multiple @TaskAction methods accepting an %s parameter.", InputChanges.class.getSimpleName()));
                    }
                    foundIncrementalTaskActionFactory = (IncrementalTaskActionFactory)taskActionFactory;
                    continue;
                }
                taskActionFactoriesBuilder.add((Object)taskActionFactory);
            }
        }
        if (foundIncrementalTaskActionFactory != null) {
            taskActionFactoriesBuilder.add(foundIncrementalTaskActionFactory);
        }
        return new TaskClassInfo((ImmutableList<TaskActionFactory>)taskActionFactoriesBuilder.build(), cacheable, reasonNotToTrackState);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static TaskActionFactory createTaskAction(Class<? extends Task> taskType, Method method) {
        void var4_7;
        if (method.getAnnotation(TaskAction.class) == null) {
            return null;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        if (Modifier.isStatic(method.getModifiers())) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on static method %s.%s().", declaringClass.getSimpleName(), method.getName()));
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes multiple parameters.", declaringClass.getSimpleName(), method.getName()));
        }
        if (parameterTypes.length == 1) {
            Class<?> parameterType = parameterTypes[0];
            if (!parameterType.equals(InputChanges.class)) throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() because %s is not a valid parameter to an action method.", declaringClass.getSimpleName(), method.getName(), parameterType));
            IncrementalTaskActionFactory incrementalTaskActionFactory = new IncrementalTaskActionFactory(taskType, method);
            return var4_7;
        } else {
            StandardTaskActionFactory standardTaskActionFactory = new StandardTaskActionFactory(taskType, method);
        }
        return var4_7;
    }

    private static class IncrementalTaskActionFactory
    implements TaskActionFactory {
        private final Class<? extends Task> taskType;
        private final Method method;

        public IncrementalTaskActionFactory(Class<? extends Task> taskType, Method method) {
            this.taskType = taskType;
            this.method = method;
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public Action<? super Task> create(Instantiator instantiator) {
            return new IncrementalTaskAction(this.taskType, this.method);
        }
    }

    private static class StandardTaskActionFactory
    implements TaskActionFactory {
        private final Class<? extends Task> taskType;
        private final Method method;

        public StandardTaskActionFactory(Class<? extends Task> taskType, Method method) {
            this.taskType = taskType;
            this.method = method;
        }

        @Override
        public Action<? super Task> create(Instantiator instantiator) {
            return new StandardTaskAction(this.taskType, this.method);
        }
    }
}

