/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.artifacts.DefaultResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.Describables;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.resolve.resolver.ArtifactResolver;
import org.gradle.internal.resolve.result.BuildableArtifactResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableArtifactFileResolveResult;

class RepositoryChainArtifactResolver
implements ArtifactResolver {
    private final Map<String, ModuleComponentRepository<?>> repositories = new LinkedHashMap();
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;

    RepositoryChainArtifactResolver(CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
    }

    void add(ModuleComponentRepository<?> repository) {
        this.repositories.put(repository.getId(), repository);
    }

    @Override
    public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
        ModuleComponentRepository<?> sourceRepository = this.findSourceRepository(component.getSources());
        sourceRepository.getLocalAccess().resolveArtifactsWithType(component.getMetadata(), artifactType, result);
        if (!result.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifactsWithType(component.getMetadata(), artifactType, result);
        }
    }

    @Override
    public void resolveArtifact(ComponentArtifactResolveMetadata component, ComponentArtifactMetadata artifact, BuildableArtifactResolveResult result) {
        ModuleComponentRepository<?> sourceRepository = this.findSourceRepository(component.getSources());
        ResolvableArtifact resolvableArtifact = sourceRepository.getArtifactCache().computeIfAbsent(artifact.getId(), id -> {
            CalculatedValueContainer artifactSource = this.calculatedValueContainerFactory.create(Describables.of((Object)artifact.getId()), () -> this.resolveArtifactLater(artifact, component.getSources(), sourceRepository));
            return new DefaultResolvableArtifact(component.getModuleVersionId(), artifact.getName(), artifact.getId(), context -> context.add((Object)artifact.getBuildDependencies()), (CalculatedValue<File>)artifactSource, this.calculatedValueContainerFactory);
        });
        result.resolved(resolvableArtifact);
    }

    private File resolveArtifactLater(ComponentArtifactMetadata artifact, ModuleSources sources, ModuleComponentRepository<?> sourceRepository) {
        DefaultBuildableArtifactFileResolveResult artifactFile = new DefaultBuildableArtifactFileResolveResult();
        sourceRepository.getLocalAccess().resolveArtifact(artifact, sources, artifactFile);
        if (!artifactFile.hasResult()) {
            sourceRepository.getRemoteAccess().resolveArtifact(artifact, sources, artifactFile);
        }
        return artifactFile.getResult();
    }

    private ModuleComponentRepository<?> findSourceRepository(ModuleSources sources) {
        RepositoryChainModuleSource repositoryChainModuleSource = sources.getSource(RepositoryChainModuleSource.class).get();
        ModuleComponentRepository<?> moduleVersionRepository = this.repositories.get(repositoryChainModuleSource.getRepositoryId());
        if (moduleVersionRepository == null) {
            throw new IllegalStateException("Attempting to resolve artifacts from invalid repository");
        }
        return moduleVersionRepository;
    }
}

