/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.transform.ComponentVariantIdentifier;
import org.gradle.api.internal.artifacts.transform.TransformStep;
import org.gradle.api.internal.artifacts.transform.TransformStepNode;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependencies;
import org.gradle.internal.id.ConfigurationCacheableIdFactory;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@ServiceScope(value={Scopes.BuildTree.class})
@ThreadSafe
public class TransformStepNodeFactory {
    private final ConfigurationCacheableIdFactory idFactory;

    public TransformStepNodeFactory(ConfigurationCacheableIdFactory idFactory) {
        this.idFactory = idFactory;
    }

    public TransformStepNode.InitialTransformStepNode createInitial(ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        long transformStepNodeId = this.idFactory.createId();
        return new TransformStepNode.InitialTransformStepNode(transformStepNodeId, targetComponentVariant, sourceAttributes, initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public TransformStepNode.InitialTransformStepNode recreateInitial(long transformStepNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep initial, ResolvableArtifact artifact, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.idFactory.idRecreated();
        return new TransformStepNode.InitialTransformStepNode(transformStepNodeId, targetComponentVariant, sourceAttributes, initial, artifact, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public TransformStepNode.ChainedTransformStepNode createChained(ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep current, TransformStepNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        long transformStepNodeId = this.idFactory.createId();
        return new TransformStepNode.ChainedTransformStepNode(transformStepNodeId, targetComponentVariant, sourceAttributes, current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }

    public TransformStepNode.ChainedTransformStepNode recreateChained(long transformStepNodeId, ComponentVariantIdentifier targetComponentVariant, AttributeContainer sourceAttributes, TransformStep current, TransformStepNode previous, TransformUpstreamDependencies upstreamDependencies, BuildOperationExecutor buildOperationExecutor, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.idFactory.idRecreated();
        return new TransformStepNode.ChainedTransformStepNode(transformStepNodeId, targetComponentVariant, sourceAttributes, current, previous, upstreamDependencies, buildOperationExecutor, calculatedValueContainerFactory);
    }
}

