/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.spi.Indexer;

public abstract class AbstractIndexerProvider
implements Indexer {
    protected List<String> externalSelectors;
    protected Pattern externalPathPattern;

    AbstractIndexerProvider() {
        Properties properties = new Properties();
        Class<?> clazz = this.getClass();
        try (InputStream is = clazz.getClassLoader().getResourceAsStream(clazz.getName().replace('.', '/') + ".properties");){
            if (is != null) {
                properties.load(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.init(properties);
    }

    protected void init(Properties properties) {
        String selectors = properties.getProperty("selectors");
        this.externalSelectors = selectors == null ? null : Arrays.asList(selectors.split(","));
        String pathRegExp = properties.getProperty("pathRegExp");
        this.externalPathPattern = pathRegExp == null ? null : Pattern.compile(pathRegExp);
    }

    protected List<String> getExternalSelectors() {
        return this.externalSelectors;
    }

    protected Pattern getExternalPathPattern() {
        return this.externalPathPattern;
    }

    @Override
    public String[] getSelectors() {
        return this.externalSelectors == null ? null : this.externalSelectors.toArray(new String[this.externalSelectors.size()]);
    }

    @Override
    public Pattern getPathPattern() {
        return this.externalPathPattern;
    }

    protected static void addToIndex(Indexes indexes, String indexName, Set<String> set, Container.Entry entry) {
        if (set.size() > 0) {
            Map<String, Collection> index = indexes.getIndex(indexName);
            for (String key : set) {
                index.get(key).add(entry);
            }
        }
    }
}

