require '_h2ph_pre.ph';

no warnings qw(redefine misc);

if(defined(&_KERNEL_OPT)) {
    require './sparc64/opt_param.ph';
    require './sparc64/opt_sparc_arch.ph';
}
if(defined(&__arch64__)) {
    eval 'sub _MACHINE () { &sparc64;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc64";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc64;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc64";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC64;}' unless defined(&MID_MACHINE);
} else {
    eval 'sub _MACHINE () { &sparc;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"sparc";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &sparc;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"sparc";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_SPARC;}' unless defined(&MID_MACHINE);
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	require 'machine/cpu.ph';
    }
}
eval 'sub ALIGNBYTES32 () {0x7;}' unless defined(&ALIGNBYTES32);
eval 'sub ALIGNBYTES64 () {0xf;}' unless defined(&ALIGNBYTES64);
unless(defined(&ALIGN32)) {
    sub ALIGN32 {
	my($p) = @_;
	eval q(((($p) +  &ALIGNBYTES32) & ~ &ALIGNBYTES32));
    }
}
if((defined(&_KERNEL) || defined(&_STANDALONE))  && !defined(&_LOCORE)) {
}
if(defined(&__arch64__)) {
    if(defined(&SUN4V)) {
	eval 'sub MAXCPUS () {256;}' unless defined(&MAXCPUS);
    }
    eval 'sub SSIZE () {2;}' unless defined(&SSIZE);
} else {
    eval 'sub SSIZE () {2;}' unless defined(&SSIZE);
}
eval 'sub USPACE () {( &SSIZE*8192);}' unless defined(&USPACE);
eval 'sub KERNBASE () {0x1000000;}' unless defined(&KERNBASE);
eval 'sub KERNEND () {0xe0000000;}' unless defined(&KERNEND);
eval 'sub _MAXNBPG () {8192;}' unless defined(&_MAXNBPG);
eval 'sub MSGBUF_VA () {(  &KERNEND +  &_MAXNBPG);}' unless defined(&MSGBUF_VA);
eval 'sub INTSTACK () {(  &KERNEND + 32* &_MAXNBPG);}' unless defined(&INTSTACK);
eval 'sub EINTSTACK () {(  &INTSTACK + 4* &_MAXNBPG);}' unless defined(&EINTSTACK);
eval 'sub CPUINFO_VA () {(  &EINTSTACK );}' unless defined(&CPUINFO_VA);
eval 'sub PANICSTACK () {(  &INTSTACK + 8* &_MAXNBPG);}' unless defined(&PANICSTACK);
eval 'sub IODEV_BASE () {(  &INTSTACK + 9* &_MAXNBPG);}' unless defined(&IODEV_BASE);
eval 'sub IODEV_END () {0xf0000000;}' unless defined(&IODEV_END);
eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
unless(defined(&MCLSHIFT)) {
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
}
eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
if(!defined (&MSGBUFSIZE) ) {
    eval 'sub MSGBUFSIZE () {(4*  &NBPG);}' unless defined(&MSGBUFSIZE);
} else {
    if((defined(&INTSTACK) ? &INTSTACK : undef) - (defined(&MSGBUF_VA) ? &MSGBUF_VA : undef) - (defined(&MSGBUFSIZE) ? &MSGBUFSIZE : undef) < 0) {
	die("MSGBUFSIZE\ is\ too\ large");
    }
}
eval 'sub NKMEMPAGES_MIN_DEFAULT () {((64* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
if(defined(&__arch64__)) {
    eval 'sub NKMEMPAGES_MAX_UNLIMITED () {1;}' unless defined(&NKMEMPAGES_MAX_UNLIMITED);
} else {
    undef(&NKMEMPAGES_MAX_UNLIMITED) if defined(&NKMEMPAGES_MAX_UNLIMITED);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((2048 * 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
}
if(defined(&_KERNEL)) {
    unless(defined(&_LOCORE)) {
	unless(defined(&__HIDE_DELAY)) {
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	}
	if(defined (&SUN4US) || defined (&SUN4V)) {
	    eval 'sub CPU_ISSUN4U () {( &cputyp ==  &CPU_SUN4U);}' unless defined(&CPU_ISSUN4U);
	    eval 'sub CPU_ISSUN4US () {( &cputyp ==  &CPU_SUN4US);}' unless defined(&CPU_ISSUN4US);
	    eval 'sub CPU_ISSUN4V () {( &cputyp ==  &CPU_SUN4V);}' unless defined(&CPU_ISSUN4V);
	} else {
	    eval 'sub CPU_ISSUN4U () {(1);}' unless defined(&CPU_ISSUN4U);
	    eval 'sub CPU_ISSUN4US () {(0);}' unless defined(&CPU_ISSUN4US);
	    eval 'sub CPU_ISSUN4V () {(0);}' unless defined(&CPU_ISSUN4V);
	}
    }
}
eval 'sub CPU_SUN4 () {0;}' unless defined(&CPU_SUN4);
eval 'sub CPU_SUN4C () {1;}' unless defined(&CPU_SUN4C);
eval 'sub CPU_SUN4M () {2;}' unless defined(&CPU_SUN4M);
eval 'sub CPU_SUN4U () {3;}' unless defined(&CPU_SUN4U);
eval 'sub CPU_SUN4US () {4;}' unless defined(&CPU_SUN4US);
eval 'sub CPU_SUN4V () {5;}' unless defined(&CPU_SUN4V);
eval 'sub CPU_ISSUN4M () {(0);}' unless defined(&CPU_ISSUN4M);
eval 'sub CPU_ISSUN4C () {(0);}' unless defined(&CPU_ISSUN4C);
eval 'sub CPU_ISSUN4 () {(0);}' unless defined(&CPU_ISSUN4);
eval 'sub PGSHIFT () {13;}' unless defined(&PGSHIFT);
eval 'sub NBPG () {(1<< &PGSHIFT);}' unless defined(&NBPG);
eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
eval 'sub PCI_MAGIC_IO_RANGE () {0x100000000;}' unless defined(&PCI_MAGIC_IO_RANGE);
1;
