/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ruby.ruby.debugger.impl;

import b.h.la;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.ruby.RBundle;
import org.jetbrains.plugins.ruby.ruby.debugger.ProcessedGlobalsCollector;
import org.jetbrains.plugins.ruby.ruby.debugger.RubyDebuggerSupportUtils;
import org.jetbrains.plugins.ruby.ruby.debugger.SourcePositionConverter;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyDebuggerEvaluator;
import org.jetbrains.plugins.ruby.ruby.debugger.impl.RubyPosition;
import org.jetbrains.plugins.ruby.ruby.debugger.values.RubyDebugValueFactory;
import org.jetbrains.plugins.ruby.ruby.lang.psi.controlStructures.methods.RMethod;
import org.jetbrains.plugins.ruby.ruby.lang.psi.holders.RContainer;
import org.jetbrains.plugins.ruby.ruby.presentation.RContainerPresentationUtil;
import org.jetbrains.plugins.ruby.ruby.presentation.RMethodPresentationUtil;
import org.rubyforge.debugcommons.RubyDebuggerException;
import org.rubyforge.debugcommons.RubyDebuggerProxy;
import org.rubyforge.debugcommons.model.RubyFrame;
import org.rubyforge.debugcommons.model.RubyThread;

public class RubyStackFrame
extends XStackFrame {
    private static final Logger b;
    private static final Object a;
    protected Project myProject;
    @Nullable
    protected XSourcePosition myXSourcePosition;
    private final RubyThread c;
    private final RubyFrame d;
    protected RubyDebuggerProxy myDebuggerProxy;
    private static final long e;

    public Object getEqualityObject() {
        return a;
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            RubyStackFrame.a(0);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (node == null) {
                RubyStackFrame.a(5);
            }
            try {
                this.myDebuggerProxy.waitForDebuggerProxyReady();
                RubyDebuggerSupportUtils.addRubyVariablesToNode(this.myProject, this.myXSourcePosition, node, this.d.getVariables(), this, true, false, false);
                XValueGroup xValueGroup = RubyDebugValueFactory.createGlobalVariables(this.myProject, this.myXSourcePosition, this.myDebuggerProxy, this.b(node), this);
                node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)xValueGroup), true);
            }
            catch (RubyDebuggerException rubyDebuggerException) {
                b.info((Throwable)rubyDebuggerException);
            }
        });
    }

    private Set<String> b(@NotNull XCompositeNode xCompositeNode) {
        if (xCompositeNode == null) {
            RubyStackFrame.a(1);
        }
        ProcessedGlobalsCollector processedGlobalsCollector = new ProcessedGlobalsCollector(this.myProject, this.myXSourcePosition);
        processedGlobalsCollector.addVariableNodes(xCompositeNode, this);
        return processedGlobalsCollector.getProcessedGlobals();
    }

    public RubyStackFrame(Project project, SourcePositionConverter positionConverter, RubyDebuggerProxy debuggerProxy, RubyThread rubyThread, @NotNull RubyFrame frame) {
        if (frame == null) {
            RubyStackFrame.a(2);
        }
        this.myProject = project;
        this.c = rubyThread;
        this.d = frame;
        this.myDebuggerProxy = debuggerProxy;
        this.myXSourcePosition = positionConverter.createLocalPosition(new RubyPosition(this.d.getFile(), this.d.getLine()));
        if (this.myXSourcePosition != null && this.myXSourcePosition.getLine() < 0) {
            this.myXSourcePosition = null;
        }
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myXSourcePosition;
    }

    public boolean isInProjectFrame() {
        XSourcePosition xSourcePosition = this.getSourcePosition();
        if (xSourcePosition == null) {
            return false;
        }
        VirtualFile virtualFile = xSourcePosition.getFile();
        return ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().isInContent(virtualFile);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XSourcePosition xSourcePosition;
        long l2 = e ^ 0xB84EC8F4D43L;
        if (component == null) {
            RubyStackFrame.a(3);
        }
        if ((xSourcePosition = this.getSourcePosition()) != null) {
            VirtualFile virtualFile = xSourcePosition.getFile();
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document == null) {
                return;
            }
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(document);
            if (psiFile == null) {
                return;
            }
            boolean bl2 = this.isInProjectFrame();
            int n2 = xSourcePosition.getLine();
            if (n2 >= document.getLineCount()) {
                return;
            }
            PsiElement psiElement = psiFile.findElementAt(document.getLineStartOffset(n2));
            RContainer rContainer = (RContainer)PsiTreeUtil.getParentOfType((PsiElement)psiElement, RContainer.class);
            if (rContainer instanceof RMethod) {
                component.append(RMethodPresentationUtil.formatName((RMethod)rContainer, 1), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                component.append(" [", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append(virtualFile.getName(), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append(":", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append(String.valueOf(n2 + 1), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                component.append("]", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES));
                RContainer rContainer2 = rContainer.getParentContainer();
                if (rContainer2 != null && !(rContainer2 instanceof PsiFile)) {
                    component.append(" (", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    component.append(RContainerPresentationUtil.getContainerNameWithLocation(rContainer2, false), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                    component.append(")", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                }
            } else {
                component.append(virtualFile.getName(), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                component.append(":", RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
                component.append(String.valueOf(n2 + 1), RubyStackFrame.processAttributes(bl2, SimpleTextAttributes.REGULAR_ATTRIBUTES));
            }
            component.setIcon(AllIcons.Debugger.Frame);
        } else {
            component.append(RBundle.message((String)"ruby.debugger.stackframe.not.available"), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    public RubyThread getRubyThread() {
        return this.c;
    }

    public static SimpleTextAttributes processAttributes(boolean isInProject, @NotNull SimpleTextAttributes originalAttributes) {
        if (originalAttributes == null) {
            RubyStackFrame.a(4);
        }
        if (isInProject) {
            return originalAttributes;
        }
        return (originalAttributes.getStyle() & 2) != 0 ? SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES;
    }

    public XDebuggerEvaluator getEvaluator() {
        return this.myXSourcePosition != null ? new RubyDebuggerEvaluator(this.myProject, this, this.myDebuggerProxy) : null;
    }

    public RubyFrame getFrame() {
        return this.d;
    }

    public String getName() {
        return this.d.getName();
    }

    static {
        e = la.a(-1065471358186825284L, -4296406934665802744L, MethodHandles.lookup().lookupClass()).a(33367697182353L);
        b = Logger.getInstance(RubyStackFrame.class);
        a = new Object();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x4EAB04D86CCDL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalAttributes";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ruby/ruby/debugger/impl/RubyStackFrame";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "collectProcessedGlobals";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "customizePresentation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$computeChildren$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

