/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.highlighter.custom.tokens;

import com.intellij.ide.highlighter.custom.tokens.PrefixedTokenParser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;

public class QuotedStringParser
extends PrefixedTokenParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.highlighter.custom.tokens.QuotedStringParser");
    private final char myQuote;
    private final boolean myAllowEscapes;

    public QuotedStringParser(String quote, IElementType type, boolean allowEscapes) {
        super(quote, type);
        LOG.assertTrue(quote.length() == 1);
        this.myQuote = quote.charAt(0);
        this.myAllowEscapes = allowEscapes;
    }

    @Override
    protected int getTokenEnd(int position) {
        boolean escaped = false;
        while (position < this.myEndOffset) {
            char c = this.myBuffer.charAt(position);
            boolean escapedStatus = escaped;
            if (this.myAllowEscapes && c == '\\') {
                boolean bl = escaped = !escaped;
            }
            if (!escaped && c == this.myQuote) {
                return position + 1;
            }
            if (c == '\n') {
                return position;
            }
            if (escapedStatus && escaped) {
                escaped = false;
            }
            ++position;
        }
        return position;
    }
}

