/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.tree;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.Convertor;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointItem;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointItemsTreeController;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsGroupNode;
import com.intellij.xdebugger.impl.breakpoints.ui.tree.BreakpointsTreeCellRenderer;
import javax.swing.tree.TreePath;

public class BreakpointsCheckboxTree
extends CheckboxTree {
    private Delegate myDelegate = null;

    protected void nodeStateWillChange(CheckedTreeNode node) {
        super.nodeStateWillChange(node);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateWillChange(node);
        }
    }

    protected void onNodeStateChanged(CheckedTreeNode node) {
        super.onNodeStateChanged(node);
        if (this.myDelegate != null) {
            this.myDelegate.nodeStateDidChange(node);
        }
    }

    public void setDelegate(Delegate delegate) {
        this.myDelegate = delegate;
    }

    public BreakpointsCheckboxTree(Project project, BreakpointItemsTreeController model) {
        super(new BreakpointsTreeCellRenderer.BreakpointsCheckboxTreeCellRenderer(project), model.getRoot());
    }

    @Override
    protected void installSpeedSearch() {
        new TreeSpeedSearch((Tree)this, (Convertor<? super TreePath, String>)((Convertor)path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof BreakpointItemNode) {
                return ((BreakpointItemNode)((Object)((Object)node))).getBreakpointItem().speedSearchText();
            }
            if (node instanceof BreakpointsGroupNode) {
                return ((BreakpointsGroupNode)((Object)((Object)node))).getGroup().getName();
            }
            return "";
        }));
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean hasFocus) {
        if (value instanceof BreakpointItemNode) {
            String displayText;
            BreakpointItem breakpointItem = ((BreakpointItemNode)((Object)value)).getBreakpointItem();
            String string = displayText = breakpointItem != null ? breakpointItem.getDisplayText() : null;
            if (!StringUtil.isEmptyOrSpaces((String)displayText)) {
                return displayText;
            }
        }
        return super.convertValueToText(value, selected, expanded, leaf, row2, hasFocus);
    }

    static interface Delegate {
        public void nodeStateDidChange(CheckedTreeNode var1);

        public void nodeStateWillChange(CheckedTreeNode var1);
    }
}

