/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.EngravedTextGraphics;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JLabel;

public class EngravedLabel
extends JLabel {
    private Color myShadowColor = EngravedTextGraphics.SHADOW_COLOR;

    public EngravedLabel(String text) {
        super(text);
        this.setOpaque(false);
    }

    public EngravedLabel() {
        this("");
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (!UIUtil.isUnderDarcula()) {
            graphics = new EngravedTextGraphics((Graphics2D)graphics, 0, 1, this.getShadowColor());
        }
        super.paintComponent(graphics);
    }

    public Color getShadowColor() {
        return this.myShadowColor == null ? EngravedTextGraphics.SHADOW_COLOR : this.myShadowColor;
    }

    public void setShadowColor(Color shadowColor) {
        this.myShadowColor = shadowColor;
    }
}

