/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Capability;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.Device;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.Link;
import com.github.dockerjava.api.model.LogConfig;
import com.github.dockerjava.api.model.LxcConf;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Ulimit;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumesFrom;
import com.intellij.docker.agent.CreateContainerCmdConfig;
import java.util.Map;
import java.util.Optional;

public class CreateContainerCmdInspection
extends CreateContainerCmdConfig {
    private final InspectContainerResponse myInspectContainerResponse;

    public CreateContainerCmdInspection(InspectContainerResponse inspectContainerResponse) {
        this.myInspectContainerResponse = inspectContainerResponse;
        Optional.ofNullable(this.myInspectContainerResponse.getNetworkSettings()).map(NetworkSettings::getPorts).ifPresent(ports -> this.myInspectContainerResponse.getHostConfig().withPortBindings(ports));
    }

    private ContainerConfig getContainerConfig() {
        return this.myInspectContainerResponse.getConfig();
    }

    public HostConfig getHostConfig() {
        return this.myInspectContainerResponse.getHostConfig();
    }

    public Bind[] getBinds() {
        return this.getHostConfig().getBinds();
    }

    public Capability[] getCapAdd() {
        return this.getHostConfig().getCapAdd();
    }

    public Capability[] getCapDrop() {
        return this.getHostConfig().getCapDrop();
    }

    public String[] getCmd() {
        return this.getContainerConfig().getCmd();
    }

    public String getCpusetCpus() {
        return super.getCpusetCpus();
    }

    public Integer getCpuShares() {
        return this.getHostConfig().getCpuShares();
    }

    public Integer getCpuPeriod() {
        return this.getHostConfig().getCpuShares();
    }

    public String getCpusetMems() {
        return super.getCpusetMems();
    }

    public Integer getBlkioWeight() {
        return super.getBlkioWeight();
    }

    public Boolean getOomKillDisable() {
        return super.getOomKillDisable();
    }

    public Device[] getDevices() {
        return this.getHostConfig().getDevices();
    }

    public String[] getDns() {
        return this.getHostConfig().getDns();
    }

    public String[] getDnsSearch() {
        return this.getHostConfig().getDnsSearch();
    }

    public String[] getEntrypoint() {
        return this.getContainerConfig().getEntrypoint();
    }

    public String[] getEnv() {
        return this.getContainerConfig().getEnv();
    }

    public ExposedPort[] getExposedPorts() {
        return Optional.ofNullable(this.getContainerConfig()).map(ContainerConfig::getExposedPorts).orElse(null);
    }

    public String[] getExtraHosts() {
        return this.getHostConfig().getExtraHosts();
    }

    public String getHostName() {
        return this.getContainerConfig().getHostName();
    }

    public String getDomainName() {
        return this.getContainerConfig().getHostName();
    }

    public String getImage() {
        return this.getContainerConfig().getImage();
    }

    public Link[] getLinks() {
        return this.getHostConfig().getLinks();
    }

    public LxcConf[] getLxcConf() {
        return this.getHostConfig().getLxcConf();
    }

    public LogConfig getLogConfig() {
        return this.getHostConfig().getLogConfig();
    }

    public String getMacAddress() {
        return this.getContainerConfig().getMacAddress();
    }

    public Long getMemory() {
        return this.getHostConfig().getMemory();
    }

    public Long getMemorySwap() {
        return this.getHostConfig().getMemorySwap();
    }

    public String getName() {
        return this.myInspectContainerResponse.getName();
    }

    public String getNetworkMode() {
        return this.getHostConfig().getNetworkMode();
    }

    public Ports getPortBindings() {
        return this.getHostConfig().getPortBindings();
    }

    public String[] getPortSpecs() {
        return this.getContainerConfig().getPortSpecs();
    }

    public RestartPolicy getRestartPolicy() {
        return this.getHostConfig().getRestartPolicy();
    }

    public String getUser() {
        return this.getContainerConfig().getUser();
    }

    public Volume[] getVolumes() {
        Map volumes = this.getContainerConfig().getVolumes();
        if (volumes == null) {
            return null;
        }
        return (Volume[])volumes.keySet().stream().map(Volume::new).toArray(Volume[]::new);
    }

    public VolumesFrom[] getVolumesFrom() {
        return this.getHostConfig().getVolumesFrom();
    }

    public String getWorkingDir() {
        return this.getContainerConfig().getWorkingDir();
    }

    public Ulimit[] getUlimits() {
        return this.getHostConfig().getUlimits();
    }

    public Boolean isAttachStderr() {
        return this.getContainerConfig().getAttachStderr();
    }

    public Boolean isAttachStdin() {
        return this.getContainerConfig().getAttachStdin();
    }

    public Boolean isAttachStdout() {
        return this.getContainerConfig().getAttachStdout();
    }

    public Boolean isNetworkDisabled() {
        return this.getContainerConfig().getNetworkDisabled();
    }

    public Boolean getPrivileged() {
        return this.getHostConfig().getPrivileged();
    }

    public Boolean getPublishAllPorts() {
        return this.getHostConfig().getPublishAllPorts();
    }

    public Boolean isStdInOnce() {
        return this.getContainerConfig().getStdInOnce();
    }

    public Boolean isStdinOpen() {
        return this.getContainerConfig().getStdinOpen();
    }

    public Boolean isTty() {
        return this.getContainerConfig().getTty();
    }

    public String getPidMode() {
        return this.getHostConfig().getPidMode();
    }

    public Map<String, String> getLabels() {
        return this.getContainerConfig().getLabels();
    }
}

