/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.jobs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.jobs.DefaultGb;
import org.jetbrains.idea.perforce.perforce.jobs.JobsMasterDetails;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public class BrowsePreviewDialog
extends DialogWrapper {
    private final Project myProject;
    private final String myJobViewQueryString;
    private final List<PerforceJob> myJobs;
    private final int myMaxCount;
    private JPanel myMainPanel;
    private JobsMasterDetails myTable;

    public BrowsePreviewDialog(@NotNull Project project, @NotNull String jobViewQueryString, @NotNull List<PerforceJob> jobs, int maxCount) {
        if (project == null) {
            BrowsePreviewDialog.$$$reportNull$$$0(0);
        }
        if (jobViewQueryString == null) {
            BrowsePreviewDialog.$$$reportNull$$$0(1);
        }
        if (jobs == null) {
            BrowsePreviewDialog.$$$reportNull$$$0(2);
        }
        super(project, true);
        this.myProject = project;
        this.myJobViewQueryString = jobViewQueryString;
        this.myJobs = jobs;
        this.myMaxCount = maxCount;
        this.createUI();
        this.setTitle("Link Job to Changelist");
        this.init();
        this.setOKActionEnabled(!this.myTable.getSelectedJobs().isEmpty());
    }

    protected String getDimensionServiceKey() {
        return "org.jetbrains.idea.perforce.perforce.jobs.BrowsePreviewDialog";
    }

    private void createUI() {
        this.myMainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gb = DefaultGb.create();
        gb.gridx = 0;
        gb.anchor = 17;
        JLabel jobViewTitleLabel = new JLabel("Job View query:");
        jobViewTitleLabel.setFont(jobViewTitleLabel.getFont().deriveFont(1));
        Insets insets = gb.insets;
        gb.insets = new Insets(2, 2, 7, 2);
        this.myMainPanel.add((Component)jobViewTitleLabel, gb);
        ++gb.gridx;
        JLabel jobView = new JLabel(this.myJobViewQueryString);
        this.myMainPanel.add((Component)jobView, gb);
        gb.insets = insets;
        this.myTable = new JobsMasterDetails(this.myProject);
        this.myTable.fillTree(this.myJobs, null);
        if (this.myJobs.size() > this.myMaxCount) {
            JLabel limitExceededLabel = new JLabel(PerforceBundle.message((String)"perforce.jobs.search.limit.exceeded.warning", (Object[])new Object[]{this.myMaxCount}));
            limitExceededLabel.setForeground((Color)JBColor.RED);
            ++gb.gridy;
            gb.gridx = 0;
            gb.gridwidth = 2;
            gb.insets = new Insets(2, 2, 2, 2);
            this.myMainPanel.add((Component)limitExceededLabel, gb);
        }
        gb.gridx = 0;
        gb.gridwidth = 2;
        ++gb.gridy;
        gb.fill = 1;
        gb.weightx = 1.0;
        gb.weighty = 1.0;
        gb.anchor = 10;
        this.myMainPanel.add((Component)this.myTable.createComponent(), gb);
        this.myTable.setSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BrowsePreviewDialog.this.setOKActionEnabled(!BrowsePreviewDialog.this.myTable.getSelectedJobs().isEmpty());
            }
        });
    }

    protected void doOKAction() {
        if (!this.myTable.getSelectedJobs().isEmpty()) {
            super.doOKAction();
        }
    }

    protected JComponent createCenterPanel() {
        return this.myMainPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "jobViewQueryString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "jobs";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/perforce/perforce/jobs/BrowsePreviewDialog";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

