/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.GuardedRef;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ThrowableConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConnectionProvider {
    private int myUseCounter;
    protected GuardedRef<DatabaseConnection> myConnection;
    protected Exception myLastException;

    public abstract GuardedRef<DatabaseConnection> acquireImpl();

    @Nullable
    public DatabaseConnection getConnection() {
        return this.myConnection == null ? null : this.myConnection.get();
    }

    public int getUseCounter() {
        return this.myUseCounter;
    }

    public Exception getLastException() {
        Exception exception = this.myLastException;
        this.myLastException = null;
        return exception;
    }

    public boolean acquire() {
        if (this.myUseCounter++ == 0) {
            this.myConnection = this.acquireImpl();
        }
        return this.myConnection != null;
    }

    public void release() {
        if (--this.myUseCounter == 0) {
            this.forceRelease();
        }
    }

    private void forceRelease() {
        if (this.myConnection != null) {
            this.myConnection.close();
            this.myConnection = null;
        }
    }

    public static ConnectionProvider forElement(final @NotNull DbElement element2, final @NotNull DatabaseDepartment subsystem) {
        if (element2 == null) {
            ConnectionProvider.$$$reportNull$$$0(0);
        }
        if (subsystem == null) {
            ConnectionProvider.$$$reportNull$$$0(1);
        }
        return new ConnectionProvider(){

            @Override
            public GuardedRef<DatabaseConnection> acquireImpl() {
                try {
                    return DbImplUtil.getDatabaseConnection(element2, subsystem);
                }
                catch (ProcessCanceledException processCanceledException) {
                }
                catch (Exception e) {
                    this.myLastException = e;
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithProvider(@NotNull DbElement element2, @NotNull DatabaseDepartment subsystem, @NotNull ThrowableConsumer<ConnectionProvider, Exception> runnable) throws Exception {
        if (element2 == null) {
            ConnectionProvider.$$$reportNull$$$0(2);
        }
        if (subsystem == null) {
            ConnectionProvider.$$$reportNull$$$0(3);
        }
        if (runnable == null) {
            ConnectionProvider.$$$reportNull$$$0(4);
        }
        ConnectionProvider provider = ConnectionProvider.forElement(element2, subsystem);
        try {
            if (!provider.acquire()) {
                Exception exception = provider.getLastException();
                throw exception != null ? exception : new ProcessCanceledException();
            }
            runnable.consume((Object)provider);
        }
        finally {
            provider.release();
            assert (provider.getUseCounter() == 0);
            assert (provider.getConnection() == null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subsystem";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/access/ConnectionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "forElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runWithProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

