/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan;

import com.intellij.database.Dbms;
import com.intellij.database.DbmsExtension;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.script.ScriptModel;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ExplainPlanProvider {
    public static final DbmsExtension<ExplainPlanProvider> EP = new DbmsExtension("com.intellij.database.explainPlanProvider");
    private final Dbms myDbms;

    @Nullable
    public static ExplainPlanProvider getDefaultProvider(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return null;
        }
        for (ExplainPlanProvider provider : EP.allForDbms(dataSource.getDbms())) {
            if (!provider.isAvailableFor(dataSource)) continue;
            return provider;
        }
        return null;
    }

    protected ExplainPlanProvider(@NotNull Dbms dbms) {
        if (dbms == null) {
            ExplainPlanProvider.$$$reportNull$$$0(0);
        }
        this.myDbms = dbms;
    }

    @NotNull
    public String getName() {
        String string = this.myDbms.getDisplayName();
        if (string == null) {
            ExplainPlanProvider.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailableFor(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            ExplainPlanProvider.$$$reportNull$$$0(2);
        }
        return true;
    }

    @NotNull
    public <V> ScriptModel<V> adjustModel(@NotNull ScriptModel<V> model) {
        if (model == null) {
            ExplainPlanProvider.$$$reportNull$$$0(3);
        }
        ScriptModel<V> scriptModel = model;
        if (scriptModel == null) {
            ExplainPlanProvider.$$$reportNull$$$0(4);
        }
        return scriptModel;
    }

    @Nullable
    public abstract DataRequest.RawRequest createExplainRequest(@NotNull DataRequest.OwnerEx var1, @NotNull Consumer<PlanModel> var2, @NotNull LocalDataSource var3, @NotNull String var4, boolean var5);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/plan/ExplainPlanProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/plan/ExplainPlanProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableFor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "adjustModel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

