/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.MemoryTextStorage;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicDatabase;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.basic.BasicModel;
import com.intellij.database.model.basic.BasicSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModSingletonFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.psi.DbRenamePsiElementProcessor;
import com.intellij.database.schemaEditor.SchemaExporters;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.util.DasUtil;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.models.EditorModelUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SchemaApplyHelper {
    private final Map<DeObject, BasicModElement> myCache;
    private final DatabaseEditorContext myContext;
    private final SchemaExporters myExporter;
    private final DeModel myModel;
    private final BasicModModel myTargetModel;

    public SchemaApplyHelper(@NotNull SchemaExporters exporter, @NotNull DatabaseEditorContext context, @NotNull DeModel model) {
        if (exporter == null) {
            SchemaApplyHelper.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SchemaApplyHelper.$$$reportNull$$$0(1);
        }
        if (model == null) {
            SchemaApplyHelper.$$$reportNull$$$0(2);
        }
        this.myCache = ContainerUtil.newHashMap();
        this.myContext = context;
        this.myExporter = exporter;
        this.myModel = model;
        this.myTargetModel = new ModelFactory(new MemoryTextStorage()).createModel(context.getDbms());
    }

    @NotNull
    public DatabaseEditorContext getContext() {
        DatabaseEditorContext databaseEditorContext = this.myContext;
        if (databaseEditorContext == null) {
            SchemaApplyHelper.$$$reportNull$$$0(3);
        }
        return databaseEditorContext;
    }

    @NotNull
    public BasicModModel getTargetModel() {
        BasicModModel basicModModel = this.myTargetModel;
        if (basicModModel == null) {
            SchemaApplyHelper.$$$reportNull$$$0(4);
        }
        return basicModModel;
    }

    public boolean contains(@NotNull DeObject obj2) {
        if (obj2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(5);
        }
        return this.myCache.containsKey(obj2);
    }

    @Nullable
    public BasicModElement apply(@Nullable DeObject object) {
        BasicModElement parent2;
        if (object == null) {
            return null;
        }
        if (object instanceof DeColumn && !((DeColumn)object).isInTable() || EditorModelUtil.isStub(object)) {
            return null;
        }
        assert (object.getKind() != ObjectKind.ROOT);
        BasicModElement res2 = this.getCached(object);
        if (res2 != null && !res2.isSyncPending()) {
            return res2;
        }
        SchemaExporters.Exporter<? extends DeObject, DasObject> exporter = this.myExporter.getApplier(object);
        assert (exporter != null) : "No applier for " + object.getClass().getName();
        assert (object.model == this.myModel);
        DeObject deParent = object.getParent();
        BasicModElement basicModElement = parent2 = deParent == null ? this.createParent(object) : this.apply(deParent);
        if (parent2 == null) {
            return null;
        }
        res2 = this.getCached(object);
        if (res2 != null && !res2.isSyncPending()) {
            return res2;
        }
        if (res2 == null || res2.getParent() != parent2) {
            res2 = SchemaApplyHelper.create(parent2, object);
            this.created(object, res2);
        } else {
            res2.resetSyncPending();
        }
        exporter.apply(this, object, res2);
        exporter.applyChildren(this, object, res2);
        return res2;
    }

    private BasicModElement getCached(@Nullable DeObject object) {
        BasicModElement res2 = this.myCache.get(object);
        if (res2 != null && res2.isDropped()) {
            this.myCache.remove(object);
            return null;
        }
        return res2;
    }

    private BasicModElement createParent(DeObject object) {
        BasicElement src = DbRenamePsiElementProcessor.unwrapDeElement(object);
        if (src != null) {
            return this.copyFromBaseModel((BasicElement)ObjectUtils.assertNotNull((Object)src.getParent()));
        }
        BasicModel baseModel = SchemaApplyHelper.unwrapDeModel(this.myModel);
        return this.createSomething(object.getKind(), baseModel);
    }

    private BasicModElement createSomething(ObjectKind kind, BasicModel model) {
        BasicDatabase database = model == null ? null : model.getRoot().getCurrentDatabase();
        BasicSchema schema = database == null ? null : ModelFun.getCurrentSchema(database);
        List first = (List)this.myTargetModel.getMetaModel().getPathsToRoot(kind).first();
        assert (first != null);
        BasicModElement parent2 = (BasicModElement)((Object)this.myTargetModel.getRoot());
        int i2 = 1;
        while (i2 + 1 < first.size()) {
            ObjectKind k = (ObjectKind)first.get(first.size() - i2 - 1);
            parent2 = k == ObjectKind.DATABASE && database != null ? this.copyFromBaseModel(database) : (k == ObjectKind.SCHEMA && schema != null ? this.copyFromBaseModel(schema) : SchemaApplyHelper.createChild(parent2, k, DasUtil.NO_NAME, null));
            ++i2;
        }
        return parent2;
    }

    @NotNull
    private BasicModElement copyFromBaseModel(@NotNull BasicElement element2) {
        ObjectKind kind;
        if (element2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(6);
        }
        if ((kind = element2.getKind()) == ObjectKind.ROOT) {
            BasicModElement root2 = (BasicModElement)((Object)this.myTargetModel.getRoot());
            BasicMetaUtils.copyProperties(element2, root2, true);
            BasicModElement basicModElement = root2;
            if (basicModElement == null) {
                SchemaApplyHelper.$$$reportNull$$$0(7);
            }
            return basicModElement;
        }
        BasicModElement parent2 = this.copyFromBaseModel((BasicElement)ObjectUtils.assertNotNull((Object)element2.getParent()));
        BasicModElement basicModElement = SchemaApplyHelper.createChild(parent2, kind, element2.getName(), element2);
        if (basicModElement == null) {
            SchemaApplyHelper.$$$reportNull$$$0(8);
        }
        return basicModElement;
    }

    private static BasicModElement create(@NotNull BasicModElement parent2, @NotNull DeObject object) {
        if (parent2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(9);
        }
        if (object == null) {
            SchemaApplyHelper.$$$reportNull$$$0(10);
        }
        BasicElement src = DbRenamePsiElementProcessor.unwrapDeElement(object);
        return SchemaApplyHelper.createChild(parent2, object.getKind(), object.name, src);
    }

    @NotNull
    private static BasicModElement createChild(@NotNull BasicModElement parent2, @NotNull ObjectKind kind, @NotNull String name, @Nullable BasicElement src) {
        if (parent2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(11);
        }
        if (kind == null) {
            SchemaApplyHelper.$$$reportNull$$$0(12);
        }
        if (name == null) {
            SchemaApplyHelper.$$$reportNull$$$0(13);
        }
        BasicModElement obj2 = SchemaApplyHelper.createObject(parent2, kind, name);
        if (src != null) {
            BasicMetaUtils.copyProperties(src, obj2, true);
        }
        BasicModElement basicModElement = obj2;
        if (basicModElement == null) {
            SchemaApplyHelper.$$$reportNull$$$0(14);
        }
        return basicModElement;
    }

    @NotNull
    private static BasicModElement createObject(@NotNull BasicModElement parent2, @NotNull ObjectKind kind, @NotNull String name) {
        if (parent2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            SchemaApplyHelper.$$$reportNull$$$0(16);
        }
        if (name == null) {
            SchemaApplyHelper.$$$reportNull$$$0(17);
        }
        Family family = parent2.familyOf(kind);
        assert (family != null) : kind.code();
        BasicModElement obj2 = null;
        if (family instanceof ModSingletonFamily) {
            obj2 = (BasicModElement)((ModSingletonFamily)family).createOrGet();
        }
        if (obj2 == null) {
            obj2 = family.find(o -> {
                if (name == null) {
                    SchemaApplyHelper.$$$reportNull$$$0(21);
                }
                return o.isSyncPending() && name.equals(o.getName());
            });
        }
        if (obj2 != null) {
            obj2.resetSyncPending();
            for (ModFamily<? extends BasicModElement> modFamily : obj2.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        } else {
            obj2 = family.createNewOne();
        }
        BasicModElement basicModElement = obj2;
        if (basicModElement == null) {
            SchemaApplyHelper.$$$reportNull$$$0(18);
        }
        return basicModElement;
    }

    @Nullable
    public BasicElement getAlreadyApplied(@Nullable DeObject object) {
        BasicModElement element2 = object == null ? null : this.getCached(object);
        return element2 == null || element2.isSyncPending() ? null : element2;
    }

    protected void created(@NotNull DeObject object, @NotNull BasicModElement res2) {
        if (object == null) {
            SchemaApplyHelper.$$$reportNull$$$0(19);
        }
        if (res2 == null) {
            SchemaApplyHelper.$$$reportNull$$$0(20);
        }
        this.myCache.put(object, res2);
    }

    public void markDirty() {
        for (ModFamily modFamily : ((BasicModRoot)this.myTargetModel.getRoot()).getFamilies()) {
            modFamily.markChildrenAsSyncPending();
        }
        for (BasicModElement basicModElement : this.myTargetModel.traverser(true).traverse().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : basicModElement.getFamilies()) {
                modFamily.markChildrenAsSyncPending();
            }
        }
    }

    public void cleanup() {
        for (ModFamily modFamily : ((BasicModRoot)this.myTargetModel.getRoot()).getFamilies()) {
            modFamily.removeSyncPendingChildren();
            modFamily.sort();
        }
        for (BasicModElement basicModElement : this.myTargetModel.traverser(true).traverse().filter(BasicModElement.class)) {
            for (ModFamily<? extends BasicModElement> modFamily : basicModElement.getFamilies()) {
                modFamily.removeSyncPendingChildren();
                modFamily.sort();
            }
        }
    }

    @Nullable
    public static BasicModel unwrapDeModel(DeModel model) {
        DeModel tmpModel = model;
        while (tmpModel instanceof DeModel) {
            tmpModel = tmpModel.getModel();
        }
        return (BasicModel)ObjectUtils.tryCast((Object)tmpModel, BasicModel.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/schemaEditor/SchemaApplyHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 13: 
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "res";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/schemaEditor/SchemaApplyHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "copyFromBaseModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "copyFromBaseModel";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createObject";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "created";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createObject$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

