/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.libraries;

import com.intellij.lang.puppet.psi.PuppetLazyProxyLightElement;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PuppetLibraryUtil {
    @NonNls
    public static final String PUPPET_STUBS_ROOT_PATH = PuppetLibraryUtil.getPuppetPluginPath() + "/lib/stubs/";
    @NonNls
    public static final String PUPPET_METAPARAMETERS_STUB_TYPE_NAME = "stub__metaparams__";
    @NonNls
    private static final String PUPPET_BUILTIN_FUNCTIONS_STUBS_FILE_NAME = "stub_functions.rb";
    private static final String PUPPET_BUILTIN_FUNCTIONS_STUBS_FILE_PATH = PUPPET_STUBS_ROOT_PATH + "stub_functions.rb";

    @Nullable
    public static VirtualFile getStubsRoot() {
        return VfsUtil.findFileByIoFile((File)new File(PUPPET_STUBS_ROOT_PATH), (boolean)false);
    }

    public static boolean isFunctionsStubsFile(@NotNull VirtualFile file) {
        if (file == null) {
            PuppetLibraryUtil.$$$reportNull$$$0(0);
        }
        return FileUtil.namesEqual((String)file.getName(), (String)PUPPET_BUILTIN_FUNCTIONS_STUBS_FILE_NAME) && FileUtil.pathsEqual((String)file.getPath(), (String)PUPPET_BUILTIN_FUNCTIONS_STUBS_FILE_PATH);
    }

    public static boolean isFunctionStubElement(@NotNull PsiElement element) {
        if (element == null) {
            PuppetLibraryUtil.$$$reportNull$$$0(1);
        }
        VirtualFile elementVirtualFile = element instanceof PuppetLazyProxyLightElement ? ((PuppetLazyProxyLightElement)element).getVirtualFile() : element.getContainingFile().getVirtualFile();
        return elementVirtualFile != null && PuppetLibraryUtil.isFunctionsStubsFile(elementVirtualFile);
    }

    private static String getPuppetPluginPath() {
        Object[] variants;
        for (String string : variants = new String[]{PathManager.getPreInstalledPluginsPath(), PathManager.getPluginsPath()}) {
            String path = string + "/puppet";
            if (!FileUtil.exists((String)path)) continue;
            return path;
        }
        throw new AssertionError((Object)("Could not set up testlib: could not find plugin paths among: " + Arrays.toString(variants)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ide/libraries/PuppetLibraryUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionsStubsFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isFunctionStubElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

