/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.lang.puppet.PuppetFileType;
import com.intellij.lang.puppet.run.PuppetRunnerParameters;
import com.intellij.lang.puppet.run.PuppetRunningState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PuppetRunConfiguration
extends LocatableConfigurationBase {
    private final PuppetRunnerParameters myRunnerParameters = new PuppetRunnerParameters();

    protected PuppetRunConfiguration(Project project, ConfigurationFactory factory, String name) {
        super(project, factory, name);
    }

    public PuppetRunnerParameters getRunnerParameters() {
        return this.myRunnerParameters;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        if (null == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(0);
        }
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        if (executor == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(1);
        }
        if (env == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(2);
        }
        Project project = env.getProject();
        String path = this.myRunnerParameters.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new ExecutionException("Can't find file: " + path);
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path));
        assert (virtualFile != null);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)virtualFile, (Project)project);
        if (module == null) {
            throw new ExecutionException("Can't find module for file");
        }
        return new PuppetRunningState(env, this.myRunnerParameters);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        String path = this.myRunnerParameters.getFilePath();
        if (path == null || VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)path)) == null) {
            throw new RuntimeConfigurationException("Can't find file: " + path);
        }
        if (!FileUtilRt.extensionEquals((String)path, (String)PuppetFileType.INSTANCE.getDefaultExtension())) {
            throw new RuntimeConfigurationException("Not a Puppet file");
        }
    }

    public void writeExternal(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(3);
        }
        super.writeExternal(element);
        XmlSerializer.serializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    public void readExternal(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            PuppetRunConfiguration.$$$reportNull$$$0(4);
        }
        super.readExternal(element);
        XmlSerializer.deserializeInto((Object)this.myRunnerParameters, (Element)element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/run/PuppetRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/run/PuppetRunConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

