/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ecmascript6.completion.ES6ClassMemberCompletionProvider;
import com.intellij.lang.ecmascript6.psi.ES6Property;
import com.intellij.lang.javascript.completion.JSReferenceCompletionContributor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSPropertyNameReference;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.settings.JSApplicationSettings;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PropertyCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        PsiReference parentReference;
        Object[] parentReferences;
        if (parameters == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(2);
        }
        PsiElement parent = parameters.getPosition().getParent();
        assert (parent instanceof JSReferenceExpression);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)parent;
        PsiElement grandParent = referenceExpression.getParent();
        assert (grandParent instanceof ES6Property);
        PsiElement firstElement = grandParent.getNode().getFirstChildNode().getPsi();
        if (firstElement.isEquivalentTo((PsiElement)referenceExpression) && (parentReferences = grandParent.getReferences()).length > 0 && (parentReference = (PsiReference)ArrayUtil.getFirstElement((Object[])parentReferences)) instanceof JSPropertyNameReference) {
            boolean useOverridesCompletion = JSApplicationSettings.getInstance().isUseOverridesCompletion();
            JSReferenceCompletionContributor.calcPropertyNameReferenceVariants((JSPropertyNameReference)parentReference, parameters, result2, !useOverridesCompletion ? null : results -> {
                ArrayList newResults = ContainerUtil.newArrayListWithCapacity((int)results.size());
                for (LookupElement element : results) {
                    LookupElement lookupElement = ES6PropertyCompletionProvider.transformElementIfNeeded(grandParent, element);
                    if (lookupElement == null) continue;
                    newResults.add(lookupElement);
                }
                return newResults;
            });
        }
    }

    @Nullable
    private static LookupElement transformElementIfNeeded(@NotNull PsiElement grandParent, @NotNull LookupElement element) {
        if (grandParent == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(3);
        }
        if (element == null) {
            ES6PropertyCompletionProvider.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = element.getPsiElement();
        PsiElement classOfContext = grandParent.getParent() instanceof JSObjectLiteralExpression ? grandParent.getParent() : JSResolveUtil.getClassOfContext(grandParent);
        String lookupString = element.getLookupString();
        if (psiElement instanceof JSFunction) {
            JSAttributeList attributeList = ((JSFunction)psiElement).getAttributeList();
            if (attributeList != null && (attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE || attributeList.getAccessType() == JSAttributeList.AccessType.PROTECTED)) {
                return null;
            }
            if (classOfContext != null) {
                return LookupElementBuilder.create((Object)psiElement, (String)lookupString).withPresentableText(" " + lookupString + "(...) {...}").withIcon(AllIcons.General.OverridenMethod).withInsertHandler(ES6ClassMemberCompletionProvider.createInsertHandler(psiElement, classOfContext, lookupString));
            }
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grandParent";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/ecmascript6/completion/ES6PropertyCompletionProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompletions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "transformElementIfNeeded";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

