/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.eslint;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeStyle.AbstractConvertLineSeparatorsAction;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.linter.JSLinterConfiguration;
import com.intellij.lang.javascript.linter.JSLinterFixAction;
import com.intellij.lang.javascript.linter.JSLinterInput;
import com.intellij.lang.javascript.linter.eslint.EsLintExternalRunner;
import com.intellij.lang.javascript.linter.eslint.EslintConfiguration;
import com.intellij.lang.javascript.linter.eslint.EslintState;
import com.intellij.lang.javascript.linter.eslint.JSLinterReformatterTask;
import com.intellij.lang.javascript.linter.eslint.LinterExecutionException;
import com.intellij.lang.javascript.linter.eslint.service.ESLintLanguageService;
import com.intellij.lang.javascript.linter.eslint.service.EslintLanguageServiceClient;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.LineSeparator;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EsLintFixAction
extends JSLinterFixAction {
    public EsLintFixAction() {
        super(JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]), JSBundle.message((String)"eslint.action.fix.problems.description", (Object[])new Object[0]), JavaScriptLanguageIcons.FileTypes.Eslint);
    }

    protected EsLintFixAction(String message, String description) {
        super(message, description, null);
    }

    @Override
    @NotNull
    protected JSLinterConfiguration getConfiguration(Project project) {
        EslintConfiguration eslintConfiguration = EslintConfiguration.getInstance(project);
        if (eslintConfiguration == null) {
            EsLintFixAction.$$$reportNull$$$0(0);
        }
        return eslintConfiguration;
    }

    @Override
    protected boolean isFileAccepted(@NotNull VirtualFile file2) {
        FileType fileType;
        if (file2 == null) {
            EsLintFixAction.$$$reportNull$$$0(1);
        }
        return DialectDetector.JAVASCRIPT_FILE_TYPES.contains(fileType = file2.getFileType()) || TypeScriptUtil.TYPESCRIPT_FILE_TYPES.contains(fileType) || fileType instanceof LanguageFileType && ((LanguageFileType)fileType).getLanguage().isKindOf((Language)HTMLLanguage.INSTANCE);
    }

    @Override
    protected boolean needRefreshFilesAfter() {
        return false;
    }

    @NotNull
    protected EslintLanguageServiceClient getLanguageService(@NotNull Project project) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(2);
        }
        ESLintLanguageService eSLintLanguageService = ESLintLanguageService.getInstance(project);
        if (eSLintLanguageService == null) {
            EsLintFixAction.$$$reportNull$$$0(3);
        }
        return eSLintLanguageService;
    }

    @Nullable
    protected JSLinterInput<EslintState> createLinterInput(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            EsLintFixAction.$$$reportNull$$$0(4);
        }
        EslintState state = (EslintState)EslintConfiguration.getInstance(psiFile.getProject()).getExtendedState().getState();
        return JSLinterInput.create(psiFile.getProject(), psiFile, psiFile.getText(), state, null);
    }

    @Override
    protected Task createTask(final @NotNull Project project, @NotNull Collection<VirtualFile> scope, @NotNull Runnable completeCallback) {
        if (project == null) {
            EsLintFixAction.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            EsLintFixAction.$$$reportNull$$$0(6);
        }
        if (completeCallback == null) {
            EsLintFixAction.$$$reportNull$$$0(7);
        }
        final String linterName = JSBundle.message((String)"settings.javascript.linters.eslint.configurable.name", (Object[])new Object[0]);
        return new JSLinterReformatterTask(project, linterName, scope, completeCallback){

            @Override
            protected void runLinter(@NotNull PsiFile psiFile, @NotNull Document document) {
                String result2;
                if (psiFile == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (document == null) {
                    1.$$$reportNull$$$0(1);
                }
                VirtualFile file2 = psiFile.getVirtualFile();
                JSLinterInput<EslintState> input = EsLintFixAction.this.createLinterInput(psiFile);
                if (input == null) {
                    return;
                }
                EslintLanguageServiceClient service = EsLintFixAction.this.getLanguageService(project);
                try {
                    result2 = EsLintExternalRunner.fixFile(input, service);
                }
                catch (LinterExecutionException e) {
                    this.error(file2, e.getAnnotation().getMessage(), new IntentionAction[0]);
                    return;
                }
                if (result2 != null) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (document == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (project == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        if (psiFile == null) {
                            1.$$$reportNull$$$0(4);
                        }
                        String message = JSBundle.message((String)"javascript.linter.action.fix.problems.name", (Object[])new Object[]{linterName});
                        LineSeparator newLineSeparator = StringUtil.detectSeparators((CharSequence)result2);
                        String newLineSeparatorString = newLineSeparator != null ? newLineSeparator.getSeparatorString() : null;
                        String documentContent = StringUtil.convertLineSeparators((String)result2);
                        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)message, null, () -> {
                            if (document == null) {
                                1.$$$reportNull$$$0(5);
                            }
                            if (project == null) {
                                1.$$$reportNull$$$0(6);
                            }
                            if (psiFile == null) {
                                1.$$$reportNull$$$0(7);
                            }
                            document.setText((CharSequence)documentContent);
                            if (newLineSeparatorString != null && !StringUtil.equals((CharSequence)file2.getDetectedLineSeparator(), (CharSequence)newLineSeparatorString)) {
                                AbstractConvertLineSeparatorsAction.changeLineSeparators((Project)project, (VirtualFile)file2, (String)newLineSeparatorString);
                                DaemonCodeAnalyzer.getInstance((Project)project).restart(psiFile);
                            }
                        }, (PsiFile[])new PsiFile[0]);
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "psiFile";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "document";
                        break;
                    }
                    case 3: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runLinter";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$runLinter$1";
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$null$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completeCallback";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/eslint/EsLintFixAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageService";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isFileAccepted";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageService";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createLinterInput";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTask";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

