/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.Matcher;
import org.joni.Regex;

abstract class SearchAlgorithm {
    public static final SearchAlgorithm NONE = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "NONE";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            return textP;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return textP;
        }
    };
    public static final SearchAlgorithm SLOW = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "EXACT";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s = textP; s < end; s += enc.length(text, s, textEnd)) {
                int t;
                if (text[s] != target[targetP]) continue;
                int p = s + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s = textEnd;
            s = (s -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s, textEnd);
            while (s >= textP) {
                if (text[s] == target[targetP]) {
                    int t;
                    int p = s + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                }
                s = enc.prevCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_SB = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "EXACT_SB";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s = textP; s < end; ++s) {
                int t;
                if (text[s] != target[targetP]) continue;
                int p = s + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                }
                if (t != targetEnd) continue;
                return s;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s = textEnd;
            if ((s -= targetEnd - targetP) > textStart) {
                s = textStart;
            }
            while (s >= textP) {
                if (text[s] == target[targetP]) {
                    int t;
                    int p = s + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == text[p++]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                }
                --s;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm SLOW_IC = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "EXACT_IC";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            byte[] buf = matcher.icbuf();
            for (int s = textP; s < end; s += enc.length(text, s, textEnd)) {
                if (!this.lowerCaseMatch(target, targetP, targetEnd, text, s, textEnd, enc, buf, regex.caseFoldFlag)) continue;
                return s;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s = textEnd;
            s = (s -= targetEnd - targetP) > textStart ? textStart : enc.leftAdjustCharHead(text, adjustText, s, textEnd);
            byte[] buf = matcher.icbuf();
            while (s >= textP) {
                if (this.lowerCaseMatch(target, targetP, targetEnd, text, s, textEnd, enc, buf, regex.caseFoldFlag)) {
                    return s;
                }
                s = enc.prevCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }

        private boolean lowerCaseMatch(byte[] t, int tP, int tEnd, byte[] bytes, int p, int end, Encoding enc, byte[] buf, int caseFoldFlag) {
            IntHolder holder = new IntHolder();
            holder.value = p;
            while (tP < tEnd) {
                int lowlen = enc.mbcCaseFold(caseFoldFlag, bytes, holder, end, buf);
                if (lowlen == 1) {
                    if (t[tP++] == buf[0]) continue;
                    return false;
                }
                int q = 0;
                while (lowlen > 0) {
                    if (t[tP++] != buf[q++]) {
                        return false;
                    }
                    --lowlen;
                }
            }
            return true;
        }
    };
    public static final SearchAlgorithm SLOW_IC_SB = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "EXACT_IC_SB";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int end = textEnd;
            if ((end -= targetEnd - targetP - 1) > textRange) {
                end = textRange;
            }
            for (int s = textP; s < end; ++s) {
                int t;
                if (target[targetP] != toLowerTable[text[s] & 0xFF]) continue;
                int p = s + 1;
                for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                }
                if (t != targetEnd) continue;
                return s;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] toLowerTable = regex.enc.toLowerCaseTable();
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            int s = textEnd;
            if ((s -= targetEnd - targetP) > textStart) {
                s = textStart;
            }
            while (s >= textP) {
                if (target[targetP] == toLowerTable[text[s] & 0xFF]) {
                    int t;
                    int p = s + 1;
                    for (t = targetP + 1; t < targetEnd && target[t] == toLowerTable[text[p++] & 0xFF]; ++t) {
                    }
                    if (t == targetEnd) {
                        return s;
                    }
                }
                --s;
            }
            return -1;
        }
    };
    public static final SearchAlgorithm BM = new SearchAlgorithm(){
        private static final int BM_BACKWARD_SEARCH_LENGTH_THRESHOLD = 100;

        @Override
        public final String getName() {
            return "EXACT_BM";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            int s;
            Regex regex = matcher.regex;
            byte[] target = regex.exact;
            int targetEnd = regex.exactEnd;
            int targetP = regex.exactP;
            int end = textRange + (targetEnd - targetP) - 1;
            if (end > textEnd) {
                end = textEnd;
            }
            int tail = targetEnd - 1;
            if (regex.intMap == null) {
                for (s = textP + (targetEnd - targetP) - 1; s < end; s += regex.map[text[s] & 0xFF]) {
                    int p = s;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                }
            } else {
                while (s < end) {
                    int p = s;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return p;
                        }
                        --p;
                        --t;
                    }
                    s += regex.intMap[text[s] & 0xFF];
                }
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            int s;
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int targetP = regex.exactP;
            int targetEnd = regex.exactEnd;
            if (regex.intMapBackward == null) {
                if (s_ - range_ < 100) {
                    return SLOW.searchBackward(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
                }
                this.setBmBackwardSkip(regex, target, targetP, targetEnd);
            }
            s = textStart < (s = textEnd - (targetEnd - targetP)) ? textStart : enc.leftAdjustCharHead(text, adjustText, s, textEnd);
            while (s >= textP) {
                int t;
                int p = s;
                for (t = targetP; t < targetEnd && text[p] == target[t]; ++t) {
                    ++p;
                }
                if (t == targetEnd) {
                    return s;
                }
                s -= regex.intMapBackward[text[s] & 0xFF];
                s = enc.leftAdjustCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }

        private void setBmBackwardSkip(Regex regex, byte[] bytes, int p, int end) {
            int i;
            int[] skip;
            if (regex.intMapBackward == null) {
                skip = new int[256];
                regex.intMapBackward = skip;
            } else {
                skip = regex.intMapBackward;
            }
            int len = end - p;
            for (i = 0; i < 256; ++i) {
                skip[i] = len;
            }
            for (i = len - 1; i > 0; --i) {
                skip[bytes[i] & 0xFF] = i;
            }
        }
    };
    public static final SearchAlgorithm BM_NOT_REV = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "EXACT_BM_NOT_REV";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] target = regex.exact;
            int end = textRange;
            int targetEnd = regex.exactEnd;
            int tail = targetEnd - 1;
            int targetP = regex.exactP;
            int tlen1 = tail - targetP;
            if (end + tlen1 > textEnd) {
                end = textEnd - tlen1;
            }
            int s = textP;
            if (regex.intMap == null) {
                while (s < end) {
                    int se;
                    int p = se = s + tlen1;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return s;
                        }
                        --p;
                        --t;
                    }
                    byte skip = regex.map[text[se] & 0xFF];
                    t = s;
                    while ((s += enc.length(text, s, textEnd)) - t < skip && s < end) {
                    }
                }
            } else {
                while (s < end) {
                    int se;
                    int p = se = s + tlen1;
                    int t = tail;
                    while (text[p] == target[t]) {
                        if (t == targetP) {
                            return s;
                        }
                        --p;
                        --t;
                    }
                    int skip = regex.intMap[text[se] & 0xFF];
                    t = s;
                    while ((s += enc.length(text, s, textEnd)) - t < skip && s < end) {
                    }
                }
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            return BM.searchBackward(matcher, text, textP, adjustText, textEnd, textStart, s_, range_);
        }
    };
    public static final SearchAlgorithm MAP = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "MAP";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            for (int s = textP; s < textRange; s += enc.length(text, s, textEnd)) {
                if (map[text[s] & 0xFF] == 0) continue;
                return s;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            Encoding enc = regex.enc;
            byte[] map = regex.map;
            int s = textStart;
            if (s >= textEnd) {
                s = textEnd - 1;
            }
            while (s >= textP) {
                if (map[text[s] & 0xFF] != 0) {
                    return s;
                }
                s = enc.prevCharHead(text, adjustText, s, textEnd);
            }
            return -1;
        }
    };
    public static final SearchAlgorithm MAP_SB = new SearchAlgorithm(){

        @Override
        public final String getName() {
            return "MAP_SB";
        }

        @Override
        public final int search(Matcher matcher, byte[] text, int textP, int textEnd, int textRange) {
            Regex regex = matcher.regex;
            byte[] map = regex.map;
            for (int s = textP; s < textRange; ++s) {
                if (map[text[s] & 0xFF] == 0) continue;
                return s;
            }
            return -1;
        }

        @Override
        public final int searchBackward(Matcher matcher, byte[] text, int textP, int adjustText, int textEnd, int textStart, int s_, int range_) {
            Regex regex = matcher.regex;
            byte[] map = regex.map;
            int s = textStart;
            if (s >= textEnd) {
                s = textEnd - 1;
            }
            while (s >= textP) {
                if (map[text[s] & 0xFF] != 0) {
                    return s;
                }
                --s;
            }
            return -1;
        }
    };

    SearchAlgorithm() {
    }

    public abstract String getName();

    public abstract int search(Matcher var1, byte[] var2, int var3, int var4, int var5);

    public abstract int searchBackward(Matcher var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8);
}

