/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.actions.smartenter;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.css.util.CssPsiUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.actions.smartenter.fixers.CssFixer;
import com.intellij.psi.css.actions.smartenter.fixers.CssMissingBraceFixer;
import com.intellij.psi.css.actions.smartenter.fixers.CssMissingSemicolonFixer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Collection<CssFixer> fixers = ContainerUtil.newArrayList((Object[])new CssFixer[]{new CssMissingSemicolonFixer(), new CssMissingBraceFixer()});

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            CssSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CssSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            CssSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (!CssSmartEnterProcessor.isSuitableFile(psiFile)) {
            return false;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.complete.statement");
        boolean result = false;
        for (CssFixer fixer : fixers) {
            PsiElement elementToReformat;
            PsiElement currentElement = this.getStatementAtCaret(editor, psiFile);
            if (currentElement == null || !fixer.isApplicable(currentElement)) continue;
            boolean fixerApplied = fixer.apply(editor, currentElement);
            this.commit(editor);
            if (fixerApplied && (elementToReformat = fixer.getElementToReformat(this.getStatementAtCaret(editor, psiFile))) != null) {
                this.reformat(elementToReformat);
                this.commit(editor);
            }
            result = true;
        }
        return result;
    }

    private static boolean isSuitableFile(PsiFile file) {
        return file instanceof StylesheetFile && CssSmartEnterProcessor.hasDeclarationTerminator((StylesheetFile)file) || file instanceof XmlFile && CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file);
    }

    private static boolean hasDeclarationTerminator(StylesheetFile file) {
        return !CssPsiUtil.getDeclarationsTerminatorFromContext((PsiElement)file).isEmpty();
    }

    @Nullable
    protected PsiElement getStatementAtCaret(Editor editor, PsiFile psiFile) {
        PsiElement statementAtCaret = super.getStatementAtCaret(editor, psiFile);
        return statementAtCaret instanceof PsiWhiteSpace ? PsiTreeUtil.prevVisibleLeaf((PsiElement)statementAtCaret) : statementAtCaret;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "psiFile";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/css/actions/smartenter/CssSmartEnterProcessor";
        objectArray[2] = "process";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

