/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.osgi.core.BundleInfoAdapter;
import org.apache.ivy.osgi.repo.BundleCapabilityAndLocation;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Message;

public abstract class AbstractOSGiResolver
extends BasicResolver {
    private static final String CAPABILITY_EXTRA_ATTR = "osgi_bundle";
    private RepoDescriptor repoDescriptor = null;
    private URLRepository repository = new URLRepository();
    private RequirementStrategy requirementStrategy = RequirementStrategy.noambiguity;

    public void setRequirementStrategy(RequirementStrategy requirementStrategy) {
        this.requirementStrategy = requirementStrategy;
    }

    public void setRequirementStrategy(String string) {
        this.setRequirementStrategy(RequirementStrategy.valueOf(string));
    }

    protected void setRepoDescriptor(RepoDescriptor repoDescriptor) {
        this.repoDescriptor = repoDescriptor;
    }

    public URLRepository getRepository() {
        return this.repository;
    }

    protected void ensureInit() {
        if (this.repoDescriptor == null) {
            this.init();
        }
    }

    protected abstract void init();

    private RepoDescriptor getRepoDescriptor() {
        this.ensureInit();
        return this.repoDescriptor;
    }

    @Override
    public boolean isAllownomd() {
        return false;
    }

    @Override
    public ResolvedResource findIvyFileRef(DependencyDescriptor dependencyDescriptor, ResolveData resolveData) {
        ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
        String string = moduleRevisionId.getOrganisation();
        if (string == null) {
            throw new RuntimeException("Unsupported OSGi module Id: " + moduleRevisionId.getModuleId());
        }
        String string2 = moduleRevisionId.getName();
        Set set = this.getRepoDescriptor().findModule(string, string2);
        if (set == null || set.isEmpty()) {
            Message.verbose("\t " + string2 + " not found.");
            return null;
        }
        ResolvedResource[] resolvedResourceArray = "bundle".equals(string) ? this.findBundle(dependencyDescriptor, resolveData, set) : this.findCapability(dependencyDescriptor, resolveData, set);
        ResolvedResource resolvedResource = this.findResource(resolvedResourceArray, this.getDefaultRMDParser(dependencyDescriptor.getDependencyId()), moduleRevisionId, resolveData.getDate());
        if (resolvedResource == null) {
            Message.debug("\t" + this.getName() + ": no resource found for " + moduleRevisionId);
        }
        return resolvedResource;
    }

    public ResolvedResource[] findBundle(DependencyDescriptor dependencyDescriptor, ResolveData resolveData, Set set) {
        ResolvedResource[] resolvedResourceArray = new ResolvedResource[set.size()];
        int n = 0;
        for (ModuleDescriptor moduleDescriptor : set) {
            MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(null);
            metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
            metadataArtifactDownloadReport.setSearched(true);
            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(this, this, moduleDescriptor, metadataArtifactDownloadReport);
            MDResolvedResource mDResolvedResource = new MDResolvedResource(null, moduleDescriptor.getRevision(), resolvedModuleRevision);
            resolvedResourceArray[n++] = mDResolvedResource;
        }
        return resolvedResourceArray;
    }

    public ResolvedResource[] findCapability(DependencyDescriptor dependencyDescriptor, ResolveData resolveData, Set set) {
        ResolvedResource[] resolvedResourceArray = new ResolvedResource[set.size()];
        int n = 0;
        for (ModuleDescriptor moduleDescriptor : set) {
            IvyNode ivyNode = resolveData.getNode(moduleDescriptor.getModuleRevisionId());
            if (ivyNode != null && ivyNode.getDescriptor() != null) {
                return new ResolvedResource[]{this.buildResolvedCapabilityMd(dependencyDescriptor, ivyNode.getDescriptor())};
            }
            resolvedResourceArray[n++] = this.buildResolvedCapabilityMd(dependencyDescriptor, moduleDescriptor);
        }
        return resolvedResourceArray;
    }

    private MDResolvedResource buildResolvedCapabilityMd(DependencyDescriptor dependencyDescriptor, ModuleDescriptor moduleDescriptor) {
        String string = dependencyDescriptor.getDependencyRevisionId().getOrganisation();
        String string2 = dependencyDescriptor.getDependencyRevisionId().getName();
        String string3 = (String)moduleDescriptor.getExtraInfo().get("_osgi_export_" + string2);
        ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string, string2, string3, Collections.singletonMap(CAPABILITY_EXTRA_ATTR, moduleDescriptor.getModuleRevisionId().toString()));
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleRevisionId, "release", new Date());
        String string4 = "use_" + dependencyDescriptor.getDependencyRevisionId().getName();
        defaultModuleDescriptor.addConfiguration(BundleInfoAdapter.CONF_DEFAULT);
        defaultModuleDescriptor.addConfiguration(BundleInfoAdapter.CONF_OPTIONAL);
        defaultModuleDescriptor.addConfiguration(BundleInfoAdapter.CONF_TRANSITIVE_OPTIONAL);
        defaultModuleDescriptor.addConfiguration(new Configuration(string4));
        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(moduleDescriptor.getModuleRevisionId(), false);
        defaultDependencyDescriptor.addDependencyConfiguration("default", "default");
        defaultDependencyDescriptor.addDependencyConfiguration("optional", "optional");
        defaultDependencyDescriptor.addDependencyConfiguration("transitive-optional", "transitive-optional");
        defaultDependencyDescriptor.addDependencyConfiguration(string4, string4);
        defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
        MetadataArtifactDownloadReport metadataArtifactDownloadReport = new MetadataArtifactDownloadReport(null);
        metadataArtifactDownloadReport.setDownloadStatus(DownloadStatus.NO);
        metadataArtifactDownloadReport.setSearched(true);
        ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision(this, this, defaultModuleDescriptor, metadataArtifactDownloadReport);
        return new MDResolvedResource(null, defaultModuleDescriptor.getRevision(), resolvedModuleRevision);
    }

    @Override
    public ResolvedResource findResource(ResolvedResource[] resolvedResourceArray, ResourceMDParser resourceMDParser, ModuleRevisionId moduleRevisionId, Date date) {
        ResolvedResource resolvedResource = super.findResource(resolvedResourceArray, resourceMDParser, moduleRevisionId, date);
        String string = moduleRevisionId.getOrganisation();
        if (!"bundle".equals(string)) {
            if (resolvedResourceArray.length != 1) {
                HashMap<String, ArrayList<ResolvedResource>> hashMap = new HashMap<String, ArrayList<ResolvedResource>>();
                for (int i = 0; i < resolvedResourceArray.length; ++i) {
                    String object = ((MDResolvedResource)resolvedResourceArray[i]).getResolvedModuleRevision().getDescriptor().getExtraAttribute(CAPABILITY_EXTRA_ATTR);
                    Object object2 = (ArrayList<ResolvedResource>)hashMap.get(object);
                    if (object2 == null) {
                        object2 = new ArrayList<ResolvedResource>();
                        hashMap.put(object, (ArrayList<ResolvedResource>)object2);
                    }
                    object2.add(resolvedResourceArray[i]);
                }
                if (hashMap.keySet().size() != 1) {
                    if (this.requirementStrategy == RequirementStrategy.first) {
                        Message.warn("Ambiguity for the '" + string + "' requirement " + moduleRevisionId.getName() + ";version=" + moduleRevisionId.getRevision());
                        for (Map.Entry entry : hashMap.entrySet()) {
                            Message.warn("\t" + entry.getKey());
                            for (MDResolvedResource mDResolvedResource : (List)entry.getValue()) {
                                Message.warn("\t\t" + mDResolvedResource.getRevision() + (resolvedResource == mDResolvedResource ? " (selected)" : ""));
                            }
                        }
                    } else if (this.requirementStrategy == RequirementStrategy.noambiguity) {
                        Message.error("Ambiguity for the '" + string + "' requirement " + moduleRevisionId.getName() + ";version=" + moduleRevisionId.getRevision());
                        for (Map.Entry entry : hashMap.entrySet()) {
                            Message.error("\t" + entry.getKey());
                            for (MDResolvedResource mDResolvedResource : (List)entry.getValue()) {
                                Message.error("\t\t" + mDResolvedResource.getRevision() + (resolvedResource == mDResolvedResource ? " (best match)" : ""));
                            }
                        }
                        return null;
                    }
                }
            }
            Message.info("'" + string + "' requirement " + moduleRevisionId.getName() + ";version=" + moduleRevisionId.getRevision() + " satisfied by " + ((MDResolvedResource)resolvedResource).getResolvedModuleRevision().getId().getName() + ";" + resolvedResource.getRevision());
        }
        return resolvedResource;
    }

    @Override
    public ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        URL uRL = artifact.getUrl();
        if (uRL == null) {
            return null;
        }
        Message.verbose("\tusing url for " + artifact + ": " + uRL);
        this.logArtifactAttempt(artifact, uRL.toExternalForm());
        URLResource uRLResource = new URLResource(uRL);
        return new ResolvedResource(uRLResource, artifact.getModuleRevisionId().getRevision());
    }

    @Override
    protected void checkModuleDescriptorRevision(ModuleDescriptor moduleDescriptor, ModuleRevisionId moduleRevisionId) {
        String string = moduleRevisionId.getOrganisation();
        if (string == null || string.equals("bundle")) {
            super.checkModuleDescriptorRevision(moduleDescriptor, moduleRevisionId);
        }
    }

    @Override
    protected Collection filterNames(Collection collection) {
        this.getSettings().filterIgnore(collection);
        return collection;
    }

    @Override
    protected Collection findNames(Map map, String string) {
        if ("organisation".equals(string)) {
            return this.getRepoDescriptor().getModuleByCapbilities().keySet();
        }
        String string2 = (String)map.get("organisation");
        if (string2 == null || string2.length() == 0) {
            return Collections.EMPTY_LIST;
        }
        String string3 = (String)map.get("revision");
        if ("module".equals(string)) {
            Map map2 = this.getRepoDescriptor().getModuleByCapbilities();
            if (string2 != null) {
                Map map3 = (Map)map2.get(string2);
                if (map3 == null) {
                    return Collections.EMPTY_LIST;
                }
                HashSet hashSet = new HashSet();
                return map3.keySet();
            }
            HashSet hashSet = new HashSet();
            for (Map map4 : map2.values()) {
                this.filterCapabilityValues(hashSet, map4, map, string3);
            }
            return hashSet;
        }
        if ("revision".equals(string)) {
            String string4 = (String)map.get("module");
            ArrayList<String> arrayList = new ArrayList<String>();
            Set set = this.getRepoDescriptor().findModule(string2, string4);
            if (set != null) {
                for (ModuleDescriptor moduleDescriptor : set) {
                    arrayList.add(moduleDescriptor.getRevision());
                }
            }
            return arrayList;
        }
        if ("conf".equals(string)) {
            Object object3;
            Version version;
            String string5 = (String)map.get("module");
            if (string5 == null) {
                return Collections.EMPTY_LIST;
            }
            if (string2.equals("package")) {
                return Collections.singletonList("use_" + string5);
            }
            Set set = this.getRepoDescriptor().findModule(string2, string5);
            if (set == null) {
                return Collections.EMPTY_LIST;
            }
            String string6 = (String)map.get("revision");
            if (string6 == null) {
                return Collections.EMPTY_LIST;
            }
            try {
                version = new Version(string6);
            }
            catch (ParseException parseException) {
                return Collections.EMPTY_LIST;
            }
            Object object2 = null;
            for (Object object3 : set) {
                if (!((BundleCapabilityAndLocation)object3).getVersion().equals(version)) continue;
                object2 = object3;
            }
            if (object2 == null) {
                return Collections.EMPTY_LIST;
            }
            object3 = BundleInfoAdapter.getConfigurations(((BundleCapabilityAndLocation)object2).getBundleInfo());
            return object3;
        }
        return Collections.EMPTY_LIST;
    }

    private void filterCapabilityValues(Set set, Map map, Map map2, String string) {
        if (string == null) {
            set.addAll(map.keySet());
        } else {
            for (Map.Entry entry : map.entrySet()) {
                Iterator iterator = ((Set)entry.getValue()).iterator();
                boolean bl = false;
                while (!bl && iterator.hasNext()) {
                    ModuleDescriptor moduleDescriptor = (ModuleDescriptor)iterator.next();
                    bl = string.equals(moduleDescriptor.getRevision());
                }
                if (!bl) continue;
                set.add(entry.getKey());
            }
        }
    }

    @Override
    public Map[] listTokenValues(String[] stringArray, Map map) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        Set set = this.listTokenValues(hashSet, map);
        return set.toArray(new Map[set.size()]);
    }

    private Set listTokenValues(Set set, Map map) {
        if (set.isEmpty()) {
            return Collections.singleton(map);
        }
        HashSet hashSet = new HashSet(set);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashSet.remove("organisation");
        String string = (String)map.get("organisation");
        if (string == null || string.length() == 0) {
            return Collections.EMPTY_SET;
        }
        hashMap.put("organisation", string);
        if (string == null) {
            HashSet hashSet2 = new HashSet();
            HashMap<String, String> hashMap2 = new HashMap<String, String>(map);
            hashMap2.put("organisation", "bundle");
            hashSet2.addAll(this.listTokenValues(hashSet, hashMap2));
            hashMap2 = new HashMap(map);
            hashMap2.put("organisation", "package");
            hashSet2.addAll(this.listTokenValues(hashSet, hashMap2));
            hashMap2 = new HashMap(map);
            hashMap2.put("organisation", "service");
            hashSet2.addAll(this.listTokenValues(hashSet, hashMap2));
            return hashSet2;
        }
        Set set2 = this.getRepoDescriptor().getCapabilityValues(string);
        if (set2 == null || set2.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        hashSet.remove("module");
        String string2 = (String)map.get("module");
        if (string2 == null) {
            HashSet hashSet3 = new HashSet();
            for (String string3 : set2) {
                HashMap<String, String> hashMap3 = new HashMap<String, String>(map);
                hashMap3.put("module", string3);
                hashSet3.addAll(this.listTokenValues(hashSet, hashMap3));
            }
            return hashSet3;
        }
        hashMap.put("module", string2);
        hashSet.remove("revision");
        String string4 = (String)map.get("revision");
        if (string4 == null) {
            Set set3 = this.getRepoDescriptor().findModule(string, string2);
            if (set3 == null) {
                return Collections.EMPTY_SET;
            }
            HashSet hashSet4 = new HashSet();
            for (BundleCapabilityAndLocation bundleCapabilityAndLocation : set3) {
                HashMap<String, String> hashMap4 = new HashMap<String, String>(map);
                hashMap4.put("revision", bundleCapabilityAndLocation.getVersion().toString());
                hashSet4.addAll(this.listTokenValues(hashSet, hashMap4));
            }
            return hashSet4;
        }
        hashMap.put("revision", string4);
        hashSet.remove("conf");
        String string5 = (String)map.get("conf");
        if (string5 == null) {
            Object object3;
            Version version;
            if (string.equals("package")) {
                hashMap.put("conf", "use_" + string2);
                return Collections.singleton(hashMap);
            }
            Set set4 = this.getRepoDescriptor().findModule(string, string2);
            if (set4 == null) {
                return Collections.EMPTY_SET;
            }
            try {
                version = new Version(string4);
            }
            catch (ParseException parseException) {
                return Collections.EMPTY_SET;
            }
            Object object2 = null;
            for (Object object3 : set4) {
                if (!((BundleCapabilityAndLocation)object3).getVersion().equals(version)) continue;
                object2 = object3;
            }
            if (object2 == null) {
                return Collections.EMPTY_SET;
            }
            object3 = new HashSet();
            List list = BundleInfoAdapter.getConfigurations(((BundleCapabilityAndLocation)object2).getBundleInfo());
            for (int i = 0; i < list.size(); ++i) {
                HashMap hashMap5 = new HashMap(map);
                hashMap5.put("conf", list.get(i));
                object3.add(hashMap5);
            }
            return object3;
        }
        hashMap.put("conf", string5);
        return Collections.singleton(hashMap);
    }

    @Override
    protected long get(Resource resource, File file) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + file);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        this.getRepository().get(resource.getName(), file);
        return file.length();
    }

    @Override
    protected Resource getResource(String string) throws IOException {
        return this.getRepository().getResource(string);
    }

    @Override
    public void publish(Artifact artifact, File file, boolean bl) throws IOException {
        throw new UnsupportedOperationException();
    }

    public static class RequirementStrategy {
        public static RequirementStrategy first = new RequirementStrategy();
        public static RequirementStrategy noambiguity = new RequirementStrategy();

        public static RequirementStrategy valueOf(String string) {
            if (string.equals("first")) {
                return first;
            }
            if (string.equals("noambiguity")) {
                return noambiguity;
            }
            throw new IllegalStateException();
        }
    }
}

