/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.HashMap;
import net.sourceforge.squirrel_sql.client.gui.HtmlViewerSheet;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrame;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class FileViewerFactory {
    private static final FileViewerFactory s_instance = new FileViewerFactory();
    private final HashMap<String, HtmlViewerSheet> _sheets = new HashMap();
    private MyInternalFrameListener _lis = new MyInternalFrameListener();

    private FileViewerFactory() {
    }

    public static FileViewerFactory getInstance() {
        return s_instance;
    }

    public synchronized HtmlViewerSheet getViewer(MainFrame parent, URL url) {
        if (parent == null) {
            throw new IllegalArgumentException("MainFrame == null");
        }
        if (url == null) {
            throw new IllegalArgumentException("URL == null");
        }
        HtmlViewerSheet viewer = this._sheets.get(url.toString());
        if (viewer == null) {
            viewer = new HtmlViewerSheet(parent.getApplication(), url.toString(), url);
            viewer.addWindowListener(this._lis);
            viewer.setSize(600, 400);
            GUIUtils.centerWithinParent(viewer);
            this._sheets.put(url.toString(), viewer);
        }
        return viewer;
    }

    public synchronized void closeAllViewers() {
        HashMap<String, HtmlViewerSheet> viewers = new HashMap<String, HtmlViewerSheet>(this._sheets);
        for (HtmlViewerSheet v : viewers.values()) {
            this.removeViewer(v);
            v.dispose();
        }
    }

    private synchronized void removeViewer(HtmlViewerSheet viewer) {
        viewer.removeWindowListener(this._lis);
        this._sheets.remove(viewer.getURL().toString());
    }

    private final class MyInternalFrameListener
    extends WindowAdapter {
        private MyInternalFrameListener() {
        }

        @Override
        public void windowClosed(WindowEvent evt) {
            FileViewerFactory.this.removeViewer((HtmlViewerSheet)evt.getWindow());
        }
    }
}

