/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.db.aliasproperties;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.client.gui.db.SQLAliasSchemaDetailProperties;
import net.sourceforge.squirrel_sql.client.gui.db.aliasproperties.SchemaTableCboItem;

public class SchemaTableModel
extends DefaultTableModel {
    private static final long serialVersionUID = 1L;
    static final int IX_SCHEMA_NAME = 0;
    static final int IX_TABLE = 1;
    static final int IX_VIEW = 2;
    static final int IX_PROCEDURE = 3;
    private SQLAliasSchemaDetailProperties[] _schemaDetails;

    public SchemaTableModel(SQLAliasSchemaDetailProperties[] schemaDetails) {
        this._schemaDetails = schemaDetails;
    }

    @Override
    public Object getValueAt(int row, int column) {
        SQLAliasSchemaDetailProperties buf = this._schemaDetails[row];
        switch (column) {
            case 0: {
                return buf.getSchemaName();
            }
            case 1: {
                return SchemaTableCboItem.getItemForID(buf.getTable());
            }
            case 2: {
                return SchemaTableCboItem.getItemForID(buf.getView());
            }
            case 3: {
                return SchemaTableCboItem.getItemForID(buf.getProcedure());
            }
        }
        throw new IllegalArgumentException("Unkown column index " + column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        SQLAliasSchemaDetailProperties buf = this._schemaDetails[row];
        switch (column) {
            case 1: {
                buf.setTable(((SchemaTableCboItem)aValue).getID());
                break;
            }
            case 2: {
                buf.setView(((SchemaTableCboItem)aValue).getID());
                break;
            }
            case 3: {
                buf.setProcedure(((SchemaTableCboItem)aValue).getID());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unkown column index " + column);
            }
        }
        this.fireTableCellUpdated(row, column);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return 0 != column && column < this.getColumnCount();
    }

    @Override
    public int getRowCount() {
        if (null == this._schemaDetails) {
            return 0;
        }
        return this._schemaDetails.length;
    }

    public SQLAliasSchemaDetailProperties[] getData() {
        return this._schemaDetails;
    }

    public void updateSchemas(String[] schemaNames) {
        ArrayList<SQLAliasSchemaDetailProperties> newDetails = new ArrayList<SQLAliasSchemaDetailProperties>();
        for (int i = 0; i < schemaNames.length; ++i) {
            boolean found = false;
            for (int j = 0; j < this._schemaDetails.length; ++j) {
                if (!this._schemaDetails[j].getSchemaName().equalsIgnoreCase(schemaNames[i])) continue;
                newDetails.add(this._schemaDetails[j]);
                found = true;
                break;
            }
            if (found) continue;
            SQLAliasSchemaDetailProperties buf = new SQLAliasSchemaDetailProperties();
            buf.setSchemaName(schemaNames[i]);
            newDetails.add(buf);
        }
        this._schemaDetails = newDetails.toArray(new SQLAliasSchemaDetailProperties[newDetails.size()]);
        Arrays.sort(this._schemaDetails);
        this.fireTableDataChanged();
    }

    public void setColumnTo(int modelIndex, SchemaTableCboItem toItem) {
        for (int i = 0; i < this._schemaDetails.length; ++i) {
            if (1 == modelIndex) {
                this._schemaDetails[i].setTable(toItem.getID());
                continue;
            }
            if (2 == modelIndex) {
                this._schemaDetails[i].setView(toItem.getID());
                continue;
            }
            if (3 != modelIndex) continue;
            this._schemaDetails[i].setProcedure(toItem.getID());
        }
        this.fireTableDataChanged();
    }
}

