/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.editextras;

import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISQLPanelAction;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.editextras.EditExtrasPlugin;
import net.sourceforge.squirrel_sql.plugins.editextras.FrameWorkAcessor;
import net.sourceforge.squirrel_sql.plugins.editextras.RemoveQuotesCommand;

class RemoveQuotesAction
extends SquirrelAction
implements ISQLPanelAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(RemoveQuotesAction.class);
    private static final ILogger s_log = LoggerController.createLogger(RemoveQuotesAction.class);
    private ISession _session;
    private EditExtrasPlugin _plugin;

    RemoveQuotesAction(IApplication app, EditExtrasPlugin plugin) {
        super(app, (IResources)plugin.getResources());
        this._plugin = plugin;
    }

    public void setSQLPanel(ISQLPanelAPI panel) {
        this._session = null != panel ? panel.getSession() : null;
        this.setEnabled(null != this._session);
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            try {
                new RemoveQuotesCommand(FrameWorkAcessor.getSQLPanelAPI(this._session, this._plugin)).execute();
            }
            catch (Throwable ex) {
                String msg = s_stringMgr.getString("editextras.errorRemoveQuotes", new Object[]{ex});
                this._session.showErrorMessage(msg);
                s_log.error((Object)msg, ex);
            }
        }
    }
}

