/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.fonts;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GlyphMetrics;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MergedGlyphVector
extends GlyphVector {
    private final Font font;
    private final FontRenderContext frc;
    private final List<GlyphInfo> glyphs = new ArrayList<GlyphInfo>();

    MergedGlyphVector(Font font, FontRenderContext frc) {
        this.font = font;
        this.frc = frc;
    }

    @Override
    public Font getFont() {
        return this.font;
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.frc;
    }

    @Override
    public void performDefaultLayout() {
    }

    @Override
    public int getNumGlyphs() {
        return this.glyphs.size();
    }

    @Override
    public int getGlyphCode(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).code;
    }

    @Override
    public int[] getGlyphCodes(int beginGlyphIndex, int numEntries, int[] codeReturn) {
        int[] result = codeReturn == null ? new int[numEntries] : codeReturn;
        for (int i = 0; i < numEntries; ++i) {
            result[i] = this.getGlyphCode(beginGlyphIndex + i);
        }
        return result;
    }

    @Override
    public Rectangle2D getLogicalBounds() {
        if (this.getNumGlyphs() == 0) {
            return new Rectangle();
        }
        return this.getGlyphLogicalBounds(0).getBounds2D().createUnion(this.getGlyphLogicalBounds(this.getNumGlyphs() - 1).getBounds2D());
    }

    @Override
    public Rectangle2D getVisualBounds() {
        if (this.getNumGlyphs() == 0) {
            return new Rectangle();
        }
        return this.getGlyphVisualBounds(0).getBounds2D().createUnion(this.getGlyphVisualBounds(this.getNumGlyphs() - 1).getBounds2D());
    }

    @Override
    public Shape getOutline() {
        return this.getOutline(0.0f, 0.0f);
    }

    @Override
    public Shape getOutline(float x, float y) {
        GeneralPath result = new GeneralPath();
        int n = this.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            result.append(this.getGlyphOutline(i, x, y), false);
        }
        return result;
    }

    @Override
    public Shape getGlyphOutline(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).outline;
    }

    @Override
    public Point2D getGlyphPosition(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).position;
    }

    @Override
    public void setGlyphPosition(int glyphIndex, Point2D newPos) {
        this.glyphs.get((int)glyphIndex).position = newPos;
    }

    @Override
    public AffineTransform getGlyphTransform(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).transform;
    }

    @Override
    public void setGlyphTransform(int glyphIndex, AffineTransform newTX) {
        this.glyphs.get((int)glyphIndex).transform = newTX;
    }

    @Override
    public float[] getGlyphPositions(int beginGlyphIndex, int numEntries, float[] positionReturn) {
        float[] result = positionReturn == null ? new float[numEntries * 2] : positionReturn;
        for (int i = 0; i < numEntries; ++i) {
            Point2D point = this.getGlyphPosition(beginGlyphIndex + i);
            int aPos = i * 2;
            result[aPos] = (float)point.getX();
            result[aPos + 1] = (float)point.getY();
        }
        return result;
    }

    @Override
    public Shape getGlyphLogicalBounds(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).logicalBounds;
    }

    @Override
    public Shape getGlyphVisualBounds(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).visualBounds;
    }

    @Override
    public GlyphMetrics getGlyphMetrics(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).metrics;
    }

    @Override
    public GlyphJustificationInfo getGlyphJustificationInfo(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).info;
    }

    @Override
    public boolean equals(GlyphVector that) {
        int n = this.getNumGlyphs();
        for (int i = 0; i < n; ++i) {
            if (this.getGlyphCode(i) == that.getGlyphCode(i)) continue;
            return false;
        }
        return true;
    }

    public Font getGlyphFont(int glyphIndex) {
        return this.glyphs.get((int)glyphIndex).font;
    }

    public void appendGlyph(int code, Shape outline, Point2D position, AffineTransform transform, Shape logicalBounds, Shape visualBounds, GlyphMetrics metrics, GlyphJustificationInfo info, Font glyphFont) {
        GlyphInfo glyph = new GlyphInfo(code, outline, position, transform, logicalBounds, visualBounds, metrics, info, glyphFont);
        this.glyphs.add(glyph);
    }

    public List<MergedGlyphVector> split() {
        ArrayList<MergedGlyphVector> list = new ArrayList<MergedGlyphVector>();
        int glyphCount = this.glyphs.size();
        if (glyphCount > 0) {
            int topStartIndex = 0;
            for (int i = 0; i < glyphCount; ++i) {
                MergedGlyphVector cgv;
                GlyphInfo info = this.glyphs.get(i);
                if (this.font.equals(info.font)) continue;
                if (topStartIndex < i) {
                    cgv = new MergedGlyphVector(this.font, this.frc);
                    cgv.glyphs.addAll(this.glyphs.subList(topStartIndex, i));
                    list.add(cgv);
                }
                cgv = new MergedGlyphVector(info.font, this.frc);
                cgv.glyphs.add(this.glyphs.get(i));
                list.add(cgv);
                topStartIndex = i + 1;
            }
            if (topStartIndex < glyphCount) {
                MergedGlyphVector cgv = new MergedGlyphVector(this.font, this.frc);
                cgv.glyphs.addAll(this.glyphs.subList(topStartIndex, glyphCount));
                list.add(cgv);
            }
        }
        return list;
    }

    private static class GlyphInfo {
        final int code;
        final Shape outline;
        Point2D position;
        AffineTransform transform;
        final Shape logicalBounds;
        final Shape visualBounds;
        final GlyphMetrics metrics;
        final GlyphJustificationInfo info;
        final Font font;

        GlyphInfo(int code, Shape outline, Point2D position, AffineTransform transform, Shape logicalBounds, Shape visualBounds, GlyphMetrics metrics, GlyphJustificationInfo info, Font font) {
            this.code = code;
            this.outline = outline;
            this.position = position;
            this.transform = transform;
            this.logicalBounds = logicalBounds;
            this.visualBounds = visualBounds;
            this.metrics = metrics;
            this.info = info;
            this.font = font;
        }
    }
}

