/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.graph;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerFacade;
import net.sourceforge.squirrel_sql.plugins.graph.GraphControllerPopupListener;
import net.sourceforge.squirrel_sql.plugins.graph.GraphPluginResources;

public class StartButtonHandler {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(StartButtonHandler.class);
    private JToggleButton _btnShowMenu;
    private Timer _popupReopenWaitTimer = new Timer(100, null);

    public StartButtonHandler(final GraphControllerFacade graphControllerFacade, GraphPluginResources rsrc) {
        this._popupReopenWaitTimer.setRepeats(false);
        this._btnShowMenu = new JToggleButton(rsrc.getIcon("Showmenu"));
        this._btnShowMenu.setToolTipText(s_stringMgr.getString("graph.StartButtonHandler.Kickoff"));
        this._btnShowMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StartButtonHandler.this.onShowmenu(graphControllerFacade);
            }
        });
    }

    public JToggleButton getButton() {
        return this._btnShowMenu;
    }

    private void onShowmenu(GraphControllerFacade graphControllerFacade) {
        if (this._btnShowMenu.isSelected() && !this._popupReopenWaitTimer.isRunning()) {
            Point loc = GUIUtils.getScreenLocationFor((Component)this._btnShowMenu);
            GraphControllerPopupListener graphControllerPopupListener = new GraphControllerPopupListener(){

                @Override
                public void hiding() {
                    StartButtonHandler.this.onPopupHide();
                }
            };
            graphControllerFacade.showPopupAbove(loc, graphControllerPopupListener);
        } else {
            graphControllerFacade.hidePopup();
            this._btnShowMenu.setSelected(false);
        }
    }

    private void onPopupHide() {
        this._btnShowMenu.setSelected(false);
        this._popupReopenWaitTimer.restart();
    }
}

