/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.zookeeper.inspector.gui.nodeviewer.ZooInspectorNodeViewer;
import org.apache.zookeeper.inspector.manager.ZooInspectorNodeManager;

public class ZooInspectorNodeViewersPanel
extends JPanel
implements TreeSelectionListener,
ChangeListener {
    private final List<ZooInspectorNodeViewer> nodeVeiwers = new ArrayList<ZooInspectorNodeViewer>();
    private final List<Boolean> needsReload = new ArrayList<Boolean>();
    private final JTabbedPane tabbedPane;
    private final List<String> selectedNodes = new ArrayList<String>();
    private final ZooInspectorNodeManager zooInspectorManager;

    public ZooInspectorNodeViewersPanel(ZooInspectorNodeManager zooInspectorManager, List<ZooInspectorNodeViewer> nodeVeiwers) {
        this.zooInspectorManager = zooInspectorManager;
        this.setLayout(new BorderLayout());
        this.tabbedPane = new JTabbedPane(1, 0);
        this.setNodeViewers(nodeVeiwers);
        this.tabbedPane.addChangeListener(this);
        this.add((Component)this.tabbedPane, "Center");
        this.reloadSelectedViewer();
    }

    public void setNodeViewers(List<ZooInspectorNodeViewer> nodeViewers) {
        this.nodeVeiwers.clear();
        this.nodeVeiwers.addAll(nodeViewers);
        this.needsReload.clear();
        this.tabbedPane.removeAll();
        for (ZooInspectorNodeViewer nodeViewer : this.nodeVeiwers) {
            nodeViewer.setZooInspectorManager(this.zooInspectorManager);
            this.needsReload.add(true);
            this.tabbedPane.add(nodeViewer.getTitle(), nodeViewer);
        }
        this.revalidate();
        this.repaint();
    }

    private void reloadSelectedViewer() {
        int index = this.tabbedPane.getSelectedIndex();
        if (index != -1 && this.needsReload.get(index).booleanValue()) {
            ZooInspectorNodeViewer viewer = this.nodeVeiwers.get(index);
            viewer.nodeSelectionChanged(this.selectedNodes);
            this.needsReload.set(index, false);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = e.getPaths();
        this.selectedNodes.clear();
        for (TreePath path : paths) {
            Object[] pathArray;
            boolean appended = false;
            StringBuilder sb = new StringBuilder();
            for (Object o : pathArray = path.getPath()) {
                String nodeName;
                if (o == null || (nodeName = o.toString()) == null || nodeName.length() <= 0) continue;
                appended = true;
                sb.append("/");
                sb.append(o.toString());
            }
            if (!appended) continue;
            this.selectedNodes.add(sb.toString());
        }
        for (int i = 0; i < this.needsReload.size(); ++i) {
            this.needsReload.set(i, true);
        }
        this.reloadSelectedViewer();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.reloadSelectedViewer();
    }
}

