/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.ConversionTaskDescription;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.cmd.BaseCmd;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.vmconversion.DiskImageVerifier;
import com.amazon.aes.webservices.client.vmconversion.Importer;
import com.amazon.aes.webservices.client.vmconversion.InternalException;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import com.amazon.aes.webservices.client.vmconversionschema.Manifest;
import java.io.File;
import java.net.URL;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3Service;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.impl.rest.httpclient.RestS3Service;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.security.ProviderCredentials;

public class UploadDiskImage
extends BaseCmd {
    public static final String DISK_IMAGE_DESC = "Specifies the local file name of the disk image to be uploaded. [REQUIRED]";
    public static final String TASK_DESC = "Specifies the conversion task id for the upload. [REQUIRED]";
    public static final String DRY_RUN_DESC = "Do not upload the file, only validate the disk image.";
    public static final String[] DONT_VERIFY_FORMAT_DESC = new String[]{"Do not verify the file format.  This is dangerous and may result in a failed", "conversion. "};
    public static final String[] OWNER_SAK_DESC_ = new String[]{"AWS Secret Access Key of the owner of BUCKET, to sign URLs for accessing", "the file being uploaded to S3. This parameter value is not sent to EC2.", "[REQUIRED]"};
    public static final int DEFAULT_PART_SIZE = 10;
    public static final long ONE_MB = 0x100000L;
    public static final String DEFAULT_USER_THREADS = "20";
    public static final String USER_THREADS = "user-threads";
    public static final String USER_THREADS_ARG = "THREADS";
    public static final String[] USER_THREADS_DESC = new String[]{"Maximum number of threads to concurrently upload the file with. Defaults to ", "20 threads. [OPTIONAL]"};
    public static final int DEFAULT_EXPIRATION = 30;
    private static final String EXPIRES_ARG = "DAYS";
    public static final String[] EXPIRES_DESC = new String[]{"Validity period for the signed S3 URLS that allow EC2 to access your file.", "Defaults to 30 days. [OPTIONAL]"};
    protected String s3AccessKey;
    protected String s3SecretKey;
    protected String taskId;
    protected File imageFile;
    protected URL manifestUrl;
    protected S3Service s3Service;
    protected String userThreads;
    protected int partSize;
    protected int expires;

    public UploadDiskImage(String[] args) {
        super("ec2udi", "ec2-upload-disk-image");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"task");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"TASK-ID");
        OptionBuilder.withDescription((String)this.joinDescription(TASK_DESC));
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"dont-verify-format");
        OptionBuilder.withDescription((String)UploadDiskImage.joinDescription(DONT_VERIFY_FORMAT_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dry-run");
        OptionBuilder.withDescription((String)this.joinDescription(DRY_RUN_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"OWNERAKID");
        OptionBuilder.withDescription((String)this.joinDescription("AWS Access Key Id of the owner of BUCKET. [REQUIRED]"));
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECRETKEY");
        OptionBuilder.withDescription((String)UploadDiskImage.joinDescription(OWNER_SAK_DESC_));
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)USER_THREADS);
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)USER_THREADS_ARG);
        OptionBuilder.withDescription((String)UploadDiskImage.joinDescription(USER_THREADS_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"expires");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)EXPIRES_ARG);
        OptionBuilder.withDescription((String)UploadDiskImage.joinDescription(EXPIRES_DESC));
        options.addOption(OptionBuilder.create((String)"x"));
        return options;
    }

    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] disk-image";
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Upload the disk image associated with the conversion task id.  Prior to");
        System.out.println("     upload, the disk image will be validated against the expected format");
        System.out.println("     for the conversion task.  If a previous upload attempt was aborted, the");
        System.out.println("     upload will (by default) resume from where it was interrupted.");
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("task");
        this.printOption("owner-akid");
        this.printOption("owner-sak");
        this.printOption("expires");
        this.printOption(USER_THREADS);
        this.printOption("dry-run");
        this.printOption("dont-verify-format");
    }

    protected void validateAndCacheParameters() throws VerificationException, GeneralError {
        this.assertOptionSet("task");
        this.taskId = this.getOptionValue("task");
        this.assertOptionSet("owner-akid");
        this.s3AccessKey = this.getOptionValue("owner-akid");
        this.assertOptionSet("owner-sak");
        this.s3SecretKey = this.getOptionValue("owner-sak");
        this.partSize = 10;
        this.userThreads = this.isOptionSet(USER_THREADS) ? this.getOptionValue(USER_THREADS) : DEFAULT_USER_THREADS;
        this.expires = this.isOptionSet("expires") ? Integer.parseInt(this.getOptionValue("expires")) : 30;
        try {
            String imageFilename = this.getNonOptions()[0];
            this.warnIfTooManyNonOptions();
            this.imageFile = new File(imageFilename);
            if (!this.imageFile.exists()) {
                throw new VerificationException("File " + this.imageFile + " does not exist");
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new VerificationException("Required argument 'disk-image' missing (-h for usage).");
        }
        try {
            Jets3tProperties props = new Jets3tProperties();
            props.setProperty("httpclient.max-connections", this.userThreads);
            props.setProperty("threaded-service.max-thread-count", this.userThreads);
            this.s3Service = new RestS3Service((ProviderCredentials)new AWSCredentials(this.s3AccessKey, this.s3SecretKey), null, null, props);
        }
        catch (S3ServiceException e) {
            throw new GeneralError("Error accessing S3 with the given user credentials. " + e.getMessage());
        }
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        try {
            this.validateAndCacheParameters();
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        boolean dryRun = this.isOptionSet("dry-run");
        boolean verifyFormat = !this.isOptionSet("dont-verify-format");
        ConversionTaskDescription task = jec2.describeConversionTask(this.taskId);
        ImportVolumeConversionTask importTask = this.retrieveImportVolumeConversionTask(task);
        try {
            DiskImageVerifier verifier = new DiskImageVerifier(this.imageFile);
            verifier.validateFileLength(importTask.getDiskImageSize());
            if (verifyFormat) {
                verifier.validateImageFormat(importTask.getDiskImageFormat(), importTask.getVolumeSize());
            }
            this.manifestUrl = new URL(importTask.getImportManifestUrl());
            int volumeSize = importTask.getVolumeSize();
            Long part = (long)this.partSize * 0x100000L;
            String format = importTask.getDiskImageFormat();
            ManifestFactory mf = new ManifestFactory(this.s3Service);
            Manifest manifest = mf.createManifestUnlessExists(this.manifestUrl, this.imageFile, format, (long)volumeSize, part.longValue(), this.expires, dryRun);
            if (dryRun) {
                return true;
            }
            if (manifest == null) {
                System.err.println("Unexpected error, could not create manifest. ");
                return false;
            }
            String bucketName = ManifestFactory.getBucketName((S3Object)ManifestFactory.getManifestS3Object((URL)this.manifestUrl));
            Importer importer = new Importer(manifest, this.s3Service, bucketName, this.imageFile);
            importer.startOrResumeImport();
            System.out.print("The disk image for " + this.taskId + " has been uploaded to Amazon S3\n" + "where it is being converted into an ");
            if (task.getTaskType().equals("ImportVolume")) {
                System.out.print("EBS volume");
            } else {
                System.out.print("EC2 instance");
            }
            System.out.print(".  You may monitor the\nprogress of this task by running ec2-describe-conversion-tasks.  When\nthe task is completed, you may use ec2-delete-disk-image to remove the\nimage from S3.\n");
            return true;
        }
        catch (VerificationException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
        catch (InternalException e) {
            System.err.println("ERROR: " + e.getMessage());
            return false;
        }
    }

    private ImportVolumeConversionTask retrieveImportVolumeConversionTask(ConversionTaskDescription task) throws GeneralError {
        ImportVolumeConversionTask importTask = null;
        String tasktype = task.getTaskType();
        if (tasktype.equals("ImportVolume")) {
            importTask = task.getImportVolumeConversionTask();
        } else if (tasktype.equals("ImportInstance")) {
            importTask = (ImportVolumeConversionTask)task.getImportInstanceConversionTask().getVolumes().get(0);
        } else {
            throw new GeneralError("The task ID " + task + " is not a known task type.");
        }
        if (importTask == null) {
            throw new GeneralError("The task ID " + task + " has no details for uploading disk image");
        }
        return importTask;
    }

    public static void main(String[] args) {
        new UploadDiskImage(args).invoke();
    }
}

