/*
 * Decompiled with CFR 0.152.
 */
package net.sf.gogui.go;

import java.util.ArrayList;
import net.sf.gogui.go.BoardConstants;
import net.sf.gogui.go.GoColor;
import net.sf.gogui.go.GoPoint;
import net.sf.gogui.go.Move;
import net.sf.gogui.go.Score;

public final class Board {
    public static final int RULES_UNKNOWN = 0;
    public static final int RULES_CHINESE = 1;
    public static final int RULES_JAPANESE = 2;
    private boolean[][] m_mark;
    private boolean[][] m_dead;
    private int m_size;
    private int m_capturedB;
    private int m_capturedW;
    private final ArrayList m_moves = new ArrayList(361);
    private GoColor[][] m_color;
    private GoColor[][] m_score;
    private GoColor m_toMove;
    private BoardConstants m_constants;
    private GoPoint m_koPoint;
    private GoPoint[] m_allPoints;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Board(int n) {
        this.initSize(n);
    }

    public boolean bothPassed() {
        int n = this.getMoveNumber();
        if (n < 2) {
            return false;
        }
        return this.getMove(n - 1).getPoint() == null && this.getMove(n - 2).getPoint() == null;
    }

    public void calcScore() {
        Object object;
        if (!$assertionsDisabled && !this.isMarkCleared()) {
            throw new AssertionError();
        }
        boolean bl = true;
        for (int i = 0; i < this.m_allPoints.length; ++i) {
            GoPoint goPoint = this.m_allPoints[i];
            object = this.getColor(goPoint);
            this.setScore(goPoint, GoColor.EMPTY);
            if (object == GoColor.EMPTY) continue;
            bl = false;
            if (this.scoreGetDead(goPoint)) continue;
            this.setScore(goPoint, (GoColor)object);
        }
        if (bl) {
            return;
        }
        ArrayList arrayList = new ArrayList(this.getNumberPoints());
        for (int i = 0; i < this.m_allPoints.length; ++i) {
            int n;
            object = this.m_allPoints[i];
            if (this.getMark((GoPoint)object)) continue;
            arrayList.clear();
            if (this.isTerritory((GoPoint)object, arrayList, GoColor.BLACK)) {
                for (n = 0; n < arrayList.size(); ++n) {
                    this.setScore((GoPoint)arrayList.get(n), GoColor.BLACK);
                }
                continue;
            }
            this.setMark(arrayList, false);
            if (this.isTerritory((GoPoint)object, arrayList, GoColor.WHITE)) {
                for (n = 0; n < arrayList.size(); ++n) {
                    this.setScore((GoPoint)arrayList.get(n), GoColor.WHITE);
                }
                continue;
            }
            this.setMark(arrayList, false);
        }
        this.clearMark();
    }

    public boolean contains(GoPoint goPoint) {
        int n = this.getSize();
        return goPoint.getX() < n && goPoint.getY() < n;
    }

    public ArrayList getAdjacentPoints(GoPoint goPoint) {
        ArrayList<GoPoint> arrayList = new ArrayList<GoPoint>(4);
        int n = goPoint.getX();
        int n2 = goPoint.getY();
        if (n > 0) {
            arrayList.add(GoPoint.get(n - 1, n2));
        }
        if (n < this.m_size - 1) {
            arrayList.add(GoPoint.get(n + 1, n2));
        }
        if (n2 > 0) {
            arrayList.add(GoPoint.get(n, n2 - 1));
        }
        if (n2 < this.m_size - 1) {
            arrayList.add(GoPoint.get(n, n2 + 1));
        }
        return arrayList;
    }

    public GoColor getScore(GoPoint goPoint) {
        return this.m_score[goPoint.getX()][goPoint.getY()];
    }

    public int getSize() {
        return this.m_size;
    }

    public int getCapturedB() {
        return this.m_capturedB;
    }

    public int getCapturedW() {
        return this.m_capturedW;
    }

    public GoColor getColor(GoPoint goPoint) {
        return this.m_color[goPoint.getX()][goPoint.getY()];
    }

    public ArrayList getHandicapStones(int n) {
        return this.m_constants.getHandicapStones(n);
    }

    public static ArrayList getHandicapStones(int n, int n2) {
        return new BoardConstants(n).getHandicapStones(n2);
    }

    public Move getMove(int n) {
        return ((MoveRecord)this.m_moves.get((int)n)).m_move;
    }

    public GoPoint getPoint(int n) {
        return this.m_allPoints[n];
    }

    public int getMoveNumber() {
        return this.m_moves.size();
    }

    public int getNumberPoints() {
        return this.m_allPoints.length;
    }

    public void getStones(GoPoint goPoint, GoColor goColor, ArrayList arrayList) {
        if (!$assertionsDisabled && !this.isMarkCleared()) {
            throw new AssertionError();
        }
        this.findStones(goPoint, goColor, arrayList);
        this.setMark(arrayList, false);
        if (!$assertionsDisabled && !this.isMarkCleared()) {
            throw new AssertionError();
        }
    }

    public GoColor getToMove() {
        return this.m_toMove;
    }

    public void initSize(int n) {
        this.m_size = n;
        this.m_color = new GoColor[this.m_size][this.m_size];
        this.m_mark = new boolean[this.m_size][this.m_size];
        this.m_dead = new boolean[this.m_size][this.m_size];
        this.m_score = new GoColor[this.m_size][this.m_size];
        this.m_constants = new BoardConstants(n);
        this.initAllPoints();
        this.newGame();
    }

    public boolean isHandicap(GoPoint goPoint) {
        return this.m_constants.isHandicap(goPoint);
    }

    public boolean isKo(GoPoint goPoint) {
        return goPoint == this.m_koPoint;
    }

    public boolean isModified() {
        return this.m_moves.size() > 0;
    }

    public boolean isSuicide(GoPoint goPoint, GoColor goColor) {
        if (this.getColor(goPoint) != GoColor.EMPTY) {
            return false;
        }
        this.play(goPoint, goColor);
        int n = this.getMoveNumber();
        MoveRecord moveRecord = (MoveRecord)this.m_moves.get(n - 1);
        boolean bl = moveRecord.m_suicide.size() > 0;
        this.undo();
        return bl;
    }

    public void newGame() {
        for (int i = 0; i < this.m_allPoints.length; ++i) {
            this.setColor(this.m_allPoints[i], GoColor.EMPTY);
        }
        this.m_moves.clear();
        this.m_capturedB = 0;
        this.m_capturedW = 0;
        this.m_toMove = GoColor.BLACK;
        this.m_koPoint = null;
    }

    public void play(GoPoint goPoint, GoColor goColor) {
        this.play(Move.get(goPoint, goColor));
    }

    public void play(Move move) {
        GoPoint goPoint = move.getPoint();
        GoColor goColor = move.getColor();
        GoColor goColor2 = goColor.otherColor();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        GoColor goColor3 = GoColor.EMPTY;
        GoPoint goPoint2 = this.m_koPoint;
        this.m_koPoint = null;
        if (goPoint != null) {
            goColor3 = this.getColor(goPoint);
            this.setColor(goPoint, goColor);
            if (goColor != GoColor.EMPTY) {
                ArrayList arrayList3 = this.getAdjacentPoints(goPoint);
                for (int i = 0; i < arrayList3.size(); ++i) {
                    int n = arrayList.size();
                    this.checkKill((GoPoint)arrayList3.get(i), goColor2, arrayList);
                    if (arrayList.size() != n + 1) continue;
                    this.m_koPoint = (GoPoint)arrayList.get(n);
                }
                this.checkKill(goPoint, goColor, arrayList2);
                if (this.m_koPoint != null && !this.isSingleStoneSingleLib(goPoint, goColor)) {
                    this.m_koPoint = null;
                }
                if (goColor == GoColor.BLACK) {
                    this.m_capturedB += arrayList2.size();
                    this.m_capturedW += arrayList.size();
                } else {
                    this.m_capturedW += arrayList2.size();
                    this.m_capturedB += arrayList.size();
                }
            }
        }
        this.m_moves.add(new MoveRecord(this.m_toMove, move, goColor3, arrayList, arrayList2, goPoint2));
        this.m_toMove = goColor2;
    }

    public void scoreBegin(GoPoint[] goPointArray) {
        int n;
        for (n = 0; n < this.m_allPoints.length; ++n) {
            this.scoreSetDead(this.m_allPoints[n], false);
        }
        if (goPointArray != null) {
            for (n = 0; n < goPointArray.length; ++n) {
                this.scoreSetDead(goPointArray[n], true);
            }
        }
        this.calcScore();
    }

    public void scoreSetDead(GoPoint goPoint, boolean bl) {
        this.m_dead[goPoint.getX()][goPoint.getY()] = bl;
    }

    public Score scoreGet(double d, int n) {
        Score score = new Score();
        score.m_rules = n;
        score.m_komi = d;
        score.m_capturedBlack = this.m_capturedB;
        score.m_capturedWhite = this.m_capturedW;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.m_allPoints.length; ++i) {
            GoPoint goPoint = this.m_allPoints[i];
            GoColor goColor = this.getColor(goPoint);
            GoColor goColor2 = this.getScore(goPoint);
            if (goColor2 == GoColor.BLACK) {
                ++score.m_areaBlack;
                ++n2;
            } else if (goColor2 == GoColor.WHITE) {
                ++score.m_areaWhite;
                --n2;
            }
            if (goColor == GoColor.EMPTY) {
                if (goColor2 == GoColor.BLACK) {
                    ++score.m_territoryBlack;
                    ++n3;
                } else if (goColor2 == GoColor.WHITE) {
                    ++score.m_territoryWhite;
                    --n3;
                }
            }
            if (goColor == GoColor.BLACK && goColor2 == GoColor.WHITE) {
                ++score.m_capturedBlack;
                ++score.m_territoryWhite;
                --n3;
            }
            if (goColor != GoColor.WHITE || goColor2 != GoColor.BLACK) continue;
            ++score.m_capturedWhite;
            ++score.m_territoryBlack;
            ++n3;
        }
        score.m_resultChinese = (double)n2 - d;
        score.m_resultJapanese = (double)(score.m_capturedWhite - score.m_capturedBlack + n3) - d;
        score.m_result = n == 2 ? score.m_resultJapanese : score.m_resultChinese;
        return score;
    }

    public boolean scoreGetDead(GoPoint goPoint) {
        return this.m_dead[goPoint.getX()][goPoint.getY()];
    }

    public void setToMove(GoColor goColor) {
        this.m_toMove = goColor;
    }

    public void undo() {
        if (this.getMoveNumber() == 0) {
            return;
        }
        int n = this.getMoveNumber() - 1;
        MoveRecord moveRecord = (MoveRecord)this.m_moves.get(n);
        this.m_moves.remove(n);
        Move move = moveRecord.m_move;
        GoColor goColor = move.getColor();
        GoColor goColor2 = goColor.otherColor();
        GoPoint goPoint = move.getPoint();
        if (goPoint != null) {
            ArrayList arrayList = moveRecord.m_suicide;
            for (int i = 0; i < arrayList.size(); ++i) {
                GoPoint goPoint2 = (GoPoint)arrayList.get(i);
                this.setColor(goPoint2, goColor);
            }
            this.setColor(goPoint, moveRecord.m_oldColor);
            ArrayList arrayList2 = moveRecord.m_killed;
            for (int i = 0; i < arrayList2.size(); ++i) {
                GoPoint goPoint3 = (GoPoint)arrayList2.get(i);
                this.setColor(goPoint3, goColor2);
            }
            if (goColor == GoColor.BLACK) {
                this.m_capturedB -= arrayList.size();
                this.m_capturedW -= arrayList2.size();
            } else {
                this.m_capturedW -= arrayList.size();
                this.m_capturedB -= arrayList2.size();
            }
        }
        this.m_toMove = moveRecord.m_oldToMove;
        this.m_koPoint = moveRecord.m_oldKoPoint;
    }

    public void undo(int n) {
        if (!$assertionsDisabled && n < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n > this.getMoveNumber()) {
            throw new AssertionError();
        }
        for (int i = 0; i < n; ++i) {
            this.undo();
        }
    }

    private boolean isSingleStoneSingleLib(GoPoint goPoint, GoColor goColor) {
        if (this.getColor(goPoint) != goColor) {
            return false;
        }
        ArrayList arrayList = this.getAdjacentPoints(goPoint);
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            GoColor goColor2 = this.getColor((GoPoint)arrayList.get(i));
            if (!(goColor2 == GoColor.EMPTY ? ++n > 1 : goColor2 == goColor)) continue;
            return false;
        }
        return true;
    }

    private void checkKill(GoPoint goPoint, GoColor goColor, ArrayList arrayList) {
        if (!$assertionsDisabled && !this.isMarkCleared()) {
            throw new AssertionError();
        }
        ArrayList arrayList2 = new ArrayList();
        if (this.isDead(goPoint, goColor, arrayList2)) {
            arrayList.addAll(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                this.setColor((GoPoint)arrayList2.get(i), GoColor.EMPTY);
            }
        }
        this.setMark(arrayList2, false);
        if (!$assertionsDisabled && !this.isMarkCleared()) {
            throw new AssertionError();
        }
    }

    private void clearMark() {
        for (int i = 0; i < this.m_allPoints.length; ++i) {
            GoPoint goPoint = this.m_allPoints[i];
            this.setMark(goPoint, false);
        }
    }

    private void findStones(GoPoint goPoint, GoColor goColor, ArrayList arrayList) {
        GoColor goColor2 = this.getColor(goPoint);
        if (goColor2 != goColor) {
            return;
        }
        if (this.getMark(goPoint)) {
            return;
        }
        this.setMark(goPoint, true);
        arrayList.add(goPoint);
        ArrayList arrayList2 = this.getAdjacentPoints(goPoint);
        for (int i = 0; i < arrayList2.size(); ++i) {
            this.findStones((GoPoint)arrayList2.get(i), goColor, arrayList);
        }
    }

    private boolean getMark(GoPoint goPoint) {
        return this.m_mark[goPoint.getX()][goPoint.getY()];
    }

    private void initAllPoints() {
        this.m_allPoints = new GoPoint[this.m_size * this.m_size];
        int n = 0;
        for (int i = 0; i < this.m_size; ++i) {
            for (int j = 0; j < this.m_size; ++j) {
                GoPoint goPoint = GoPoint.get(i, j);
                this.m_allPoints[n++] = goPoint;
            }
        }
    }

    private boolean isDead(GoPoint goPoint, GoColor goColor, ArrayList arrayList) {
        GoColor goColor2 = this.getColor(goPoint);
        if (goColor2 == GoColor.EMPTY) {
            return false;
        }
        if (goColor2 != goColor) {
            return true;
        }
        if (this.getMark(goPoint)) {
            return true;
        }
        this.setMark(goPoint, true);
        arrayList.add(goPoint);
        ArrayList arrayList2 = this.getAdjacentPoints(goPoint);
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (this.isDead((GoPoint)arrayList2.get(i), goColor, arrayList)) continue;
            return false;
        }
        return true;
    }

    private boolean isMarkCleared() {
        for (int i = 0; i < this.m_allPoints.length; ++i) {
            if (!this.getMark(this.m_allPoints[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isTerritory(GoPoint goPoint, ArrayList arrayList, GoColor goColor) {
        GoColor goColor2 = this.getColor(goPoint);
        if (goColor2 == goColor.otherColor() && !this.scoreGetDead(goPoint)) {
            return false;
        }
        if (goColor2 == goColor) {
            return !this.scoreGetDead(goPoint);
        }
        if (this.getMark(goPoint)) {
            return true;
        }
        this.setMark(goPoint, true);
        arrayList.add(goPoint);
        ArrayList arrayList2 = this.getAdjacentPoints(goPoint);
        for (int i = 0; i < arrayList2.size(); ++i) {
            if (this.isTerritory((GoPoint)arrayList2.get(i), arrayList, goColor)) continue;
            return false;
        }
        return true;
    }

    private void setColor(GoPoint goPoint, GoColor goColor) {
        if (!$assertionsDisabled && goPoint == null) {
            throw new AssertionError();
        }
        this.m_color[goPoint.getX()][goPoint.getY()] = goColor;
    }

    private void setMark(GoPoint goPoint, boolean bl) {
        this.m_mark[goPoint.getX()][goPoint.getY()] = bl;
    }

    private void setMark(ArrayList arrayList, boolean bl) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            this.setMark((GoPoint)arrayList.get(i), bl);
        }
    }

    private void setScore(GoPoint goPoint, GoColor goColor) {
        if (!$assertionsDisabled && goColor == null) {
            throw new AssertionError();
        }
        this.m_score[goPoint.getX()][goPoint.getY()] = goColor;
    }

    static {
        $assertionsDisabled = !Board.class.desiredAssertionStatus();
    }

    private static class MoveRecord {
        public final GoPoint m_oldKoPoint;
        public final GoColor m_oldColor;
        public final GoColor m_oldToMove;
        public final Move m_move;
        public final ArrayList m_killed;
        public final ArrayList m_suicide;

        public MoveRecord(GoColor goColor, Move move, GoColor goColor2, ArrayList arrayList, ArrayList arrayList2, GoPoint goPoint) {
            this.m_oldColor = goColor2;
            this.m_oldToMove = goColor;
            this.m_move = move;
            this.m_killed = arrayList;
            this.m_suicide = arrayList2;
            this.m_oldKoPoint = goPoint;
        }
    }
}

