################################################################################
#    iGMT: Interactive Mapping of Geoscientific Datasets.                      #
#               Easy access to GMT via a Tcl/Tk GUI                            #
#                                                                              #
#    Copyright (C) 1998 - 2000  Thorsten W. Becker, Alexander Braun            #
#                                                                              #
#    This program is free software; you can redistribute it and/or modify      #
#    it under the terms of the GNU General Public License as published by      #
#    the Free Software Foundation; either version 2 of the License, or         #
#    (at your option) any later version.                                       #
#                                                                              #
#    This program is distributed in the hope that it will be useful,           #
#    but WITHOUT ANY WARRANTY; without even the implied warranty of            #
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             #
#    GNU General Public License for more details.                              #
#                                                                              #
#    In addition, iGMT is not to be used for any military purposes or          #
#    for any other activities that are against the spirit as expressed         #
#    in the Student Pugwash Pledge (www.spusa.org/pugwash/pledge.html).        #
#                                                                              #
#    You should have received a copy of the GNU General Public License         #
#    along with this program; see the file COPYING.  If not, write to          #
#    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,          #
#    Boston, MA 02111-1307, USA.                                               #
#                                                                              #
################################################################################

# igmt.tcl -- main procedure
#
# part of the iGMT package
#

################################################################################
#
#                                  iGMT, version 1.1
#
# graphical user interface for the GMT tools
# interface to various datasets 
#
# documentation in manual.ps
#
# modify variables such as path names in igmt_configure.tcl
#
#
# Thorsten Becker, Alexander Braun
#
################################################################################

# load the default settings and all the global variables
source "$env(igmt_root)/igmt_configure.tcl"

# source some site specific settings that may overwrite the defaults in a
# igmt_configure (so igmt_configure needn't be changed, if the file is not
# there, ignore the error message)

if { [catch { source "$env(igmt_root)/igmt_siteconfig.tcl" } ] == 0 } { 
    puts "iGMT: read igmt_siteconfig.tcl for local settings"
}


# adjust binaries to GMT version setting

if { $gmt_version >= $gmt_version_boundary } {
    set gmtbins $higher_version_gmtbins
} else {
    set gmtbins $lower_version_gmtbins
}








# check the availability of at least one GMT command

if { [catch "[ list exec [ format %sgmtdefaults $gmtbins ] -D > /dev/null ]" var ] } {
    puts $var
    puts "iGMT: Can't execute \"[ format %sgmtdefaults $gmtbins ]\" !"
    puts "iGMT: The GMT commands are probably in the wrong place"
    puts "iGMT: or not in your path."
    puts "iGMT: Modify $igmt_root/igmt_configure.tcl, "
    puts "iGMT: $igmt_root/igmt_siteconfig.tcl or your \$path variable."
    exit -1 
} 
#  if gmtbins is not set, request the general path
if { $gmtbins == "" } {
    if { [ catch "[ list exec $shell_to_use -c "whence gmtdefaults" ]" gmtbins ] } {
	# could not automatically determine the binary location
	puts "iGMT: Could not determine the pathname of the GMT binaries."
	puts "iGMT: Please find out where binaries such as pscoast reside"
	puts "iGMT: (type \"which pscoast\" for example) and add a line like"
	puts "iGMT: set gmtbins /the/directory/of/GMT/bin/"
	puts "iGMT: to your igmt_siteconfig.tcl file. Then restart."
	exit -1
    }
    set gmtbins [ string range $gmtbins 0 [ expr [ string length $gmtbins ] - 13 ]  ]
}

set convert_availability [catch "[ list exec $shell_to_use -c "whence $ps_to_gif_converter" ] " tmp_var ]
if { ( $convert_availability ) || ( [ string range $tmp_var  0 1 ] == "no") } {
    puts "iGMT: Couldn't check the path to the default converter,"
    puts "iGMT: \"$ps_to_gif_converter\". This means that you are probably now"
    puts "iGMT: restricted to the postscript features."

}

# igmt version number

set igmt_version 1.2


#global frame starts here
wm title . "iGMT version $igmt_version"

# load various input/output routines 
source "$env(igmt_root)/igmt_iomisc.tcl"

# call the init routine
source "$env(igmt_root)/igmt_init.tcl"   
     
# set up the menu bar with sub menus
source "$env(igmt_root)/igmt_menus.tcl"       

# load the plotting related routines
source "$env(igmt_root)/igmt_plotting.tcl"

# load the dialogs related to changing parameters
source "$env(igmt_root)/igmt_parameters.tcl"

# load the dialogs related to dataset selection
source "$env(igmt_root)/igmt_datasets.tcl"


################################################################################
# title line

label .msg -textvariable headermessage
.msg config -bg PeachPuff1
pack .msg -fill x
pack .msg .mb -side top -fill x


if { $changed_gmtdefaults == "moved" } {
    
    # remind the user here if the $env(PWD)/.gmtdefaults file was changed
    # (because we want to have something  on the screen first )

    set warningstring "The .gmtdefaults file in our working directory \"$env(PWD)\""
    set warningstring "$warningstring is different from the GMT $gmt_version default.\n\nSince these settings are "
    set warningstring "$warningstring preferred by iGMT, your file was temporarily moved to"
    set warningstring "$warningstring TEMPORARILY_MOVED_GMT_DEFAULT.\n\nIf (and only if) "
    set warningstring "$warningstring iGMT terminates abnormally you might have to copy it back yourself!"

    if { $gmt_version >= $gmt_version_boundary } { 
	set warningstring "$warningstring \nYou are using GMT >= $gmt_version_boundary, in this case we consider \"PAPER_MEDIA = letter+\""
	set warningstring "$warningstring the default instead of \"PAPER_MEDIA = letter\" since iGMT needs EPS postscript files."
    }
	

    if { $changed_gmtdefaults != "0" } { dialog .d {.gmtdefaults handling} $warningstring warning 0 {OK} }
}



################################################################################
# check the availability of data files

if { $check_for_raster_availability } {

    set files_unavailable ""

    for { set i 1 } { $i <= $nr_of_raster_data } { incr i } { 
	if { $raster_data($i)  != -1 } {
	    if { [ catch { exec test -s $raster_data($i) } ] } { 
		set files_unavailable "$files_unavailable\n$raster_data($i)\n" 
	    }
	}
    }
    if { [ string trim $files_unavailable ] != "" } {
	dialog .d {Missing data sets...} \
	    "The following data sets are unavailable:\n\n$files_unavailable\n\nThis means that some of the data handling routines will not work.\nAdd the correct filenames to your igmt_siteconfig.tcl file and look\nin igmt_configure.tcl for the default names.\nIf you want to get rid of this message, set \"check_for_raster_availability\" to 0\nin your igmt_siteconfig.tcl file.\n"  warning 0 {OK} 
    }
    
}


################################################################################
# display the map in the lower part as a GIF image

# copy the default image to fill the frame the first time if there is
# no temporary file around

#exec $igmt_root/igmt_helper_checkfile $gif_filename $def_gif_filename

image create photo map_image -file $def_gif_filename
label .mapimage -image  map_image  -bd 1 -relief sunken
pack .mapimage
pack .mb .mapimage -fill x -fill y -side top



puts "iGMT: Initialized in GMT $gmt_version mode."
#puts "iGMT: If quitting iGMT doesn't seem to get you back to the" 
#puts "iGMT: command line, hit \"RETURN\" in this shell window."

