/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.scanner;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.configuration.ConfigurationException;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.extension.CommandLineArgument;
import org.parosproxy.paros.extension.CommandLineListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.extension.history.ManualRequestEditorDialog;
import org.parosproxy.paros.extension.scanner.AlertPanel;
import org.parosproxy.paros.extension.scanner.AlertTreeModel;
import org.parosproxy.paros.extension.scanner.OptionsScannerPanel;
import org.parosproxy.paros.extension.scanner.PolicyDialog;
import org.parosproxy.paros.extension.scanner.PopupMenuResend;
import org.parosproxy.paros.extension.scanner.PopupMenuScanHistory;
import org.parosproxy.paros.extension.scanner.ProgressDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ExtensionScanner
extends ExtensionAdaptor
implements ScannerListener,
SessionChangedListener,
CommandLineListener {
    private static final int ARG_SCAN_IDX = 0;
    private JMenuItem menuItemScanAll = null;
    private ExtensionHookMenu pluginMenu = null;
    private Scanner scanner = null;
    private SiteMap siteTree = null;
    private SiteNode startNode = null;
    private AlertTreeModel treeAlert = null;
    private JMenu menuScanner = null;
    private JMenuItem menuItemPolicy = null;
    private ProgressDialog progressDialog = null;
    private JMenuItem menuItemScan = null;
    private AlertPanel alertPanel = null;
    private RecordScan recordScan = null;
    private ManualRequestEditorDialog manualRequestEditorDialog = null;
    private PopupMenuResend popupMenuResend = null;
    private OptionsScannerPanel optionsScannerPanel = null;
    private ScannerParam scannerParam = null;
    private CommandLineArgument[] arguments = new CommandLineArgument[1];
    private long startTime = 0L;
    private PopupMenuScanHistory popupMenuScanHistory = null;

    public ExtensionScanner() {
        this.initialize();
    }

    public ExtensionScanner(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionScanner");
    }

    private JMenuItem getMenuItemScanAll() {
        if (this.menuItemScanAll == null) {
            this.menuItemScanAll = new JMenuItem();
            this.menuItemScanAll.setText("Scan All");
            this.menuItemScanAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionScanner.this.menuItemScan.setEnabled(false);
                    ExtensionScanner.this.menuItemScanAll.setEnabled(false);
                    ExtensionScanner.this.getAlertPanel().setTabFocus();
                    ExtensionScanner.this.startScan();
                }
            });
        }
        return this.menuItemScanAll;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addAnalyseMenuItem(this.getMenuItemScanAll());
            extensionHook.getHookMenu().addAnalyseMenuItem(this.getMenuItemScan());
            extensionHook.getHookMenu().addAnalyseMenuItem(this.getMenuItemPolicy());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuResend());
            extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuScanHistory());
            extensionHook.getHookView().addStatusPanel(this.getAlertPanel());
            extensionHook.getHookView().addOptionPanel(this.getOptionsScannerPanel());
        }
        extensionHook.addSessionListener(this);
        extensionHook.addOptionsParamSet(this.getScannerParam());
        extensionHook.addCommandLine(this.getCommandLineArguments());
    }

    void startScan() {
        this.siteTree = this.getModel().getSession().getSiteTree();
        if (this.startNode == null) {
            this.startNode = (SiteNode)this.siteTree.getRoot();
        }
        this.startScan(this.startNode);
    }

    void startScan(SiteNode siteNode) {
        this.scanner = new Scanner(this.getScannerParam(), this.getModel().getOptionsParam().getConnectionParam());
        this.scanner.addScannerListener(this);
        if (this.getView() != null) {
            this.getProgressDialog().setVisible(true);
            this.getProgressDialog().setPluginScanner(this);
            this.menuItemScanAll.setEnabled(false);
            this.menuItemScan.setEnabled(false);
            this.getMenuItemPolicy().setEnabled(false);
            this.getPopupMenuScanHistory().setEnabled(false);
            this.getAlertPanel().setTabFocus();
        }
        try {
            this.recordScan = this.getModel().getDb().getTableScan().insert(this.getModel().getSession().getSessionId(), this.getModel().getSession().getSessionName());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.startTime = System.currentTimeMillis();
        this.scanner.start(siteNode);
    }

    public SiteNode getStartNode() {
        return this.startNode;
    }

    public void scannerComplete() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final long l = System.currentTimeMillis() - this.startTime;
        if (this.getView() != null) {
            this.getMenuItemScanAll().setEnabled(true);
            this.getMenuItemScan().setEnabled(true);
            this.getMenuItemPolicy().setEnabled(true);
            this.popupMenuScanHistory.setEnabled(true);
        }
        if (this.getView() != null && this.progressDialog != null) {
            if (EventQueue.isDispatchThread()) {
                this.progressDialog.dispose();
                this.progressDialog = null;
                this.getView().showMessageDialog("Scanning completed in " + l / 1000L + "s.  The result can be obtained from Report>Last Scan Result.");
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtensionScanner.this.progressDialog.dispose();
                        ExtensionScanner.this.progressDialog = null;
                        ExtensionScanner.this.getView().showMessageDialog("Scanning completed in " + l / 1000L + "s.  The result can be obtained from Report>Last Scan Result.");
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JMenuItem getMenuItemPolicy() {
        if (this.menuItemPolicy == null) {
            this.menuItemPolicy = new JMenuItem();
            this.menuItemPolicy.setText("Scan Policy...");
            this.menuItemPolicy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PolicyDialog policyDialog = new PolicyDialog(ExtensionScanner.this.getView().getMainFrame());
                    policyDialog.initParam(ExtensionScanner.this.getModel().getOptionsParam());
                    int n = policyDialog.showDialog(false);
                    if (n == 0) {
                        try {
                            ExtensionScanner.this.getModel().getOptionsParam().getConfig().save();
                        }
                        catch (ConfigurationException configurationException) {
                            configurationException.printStackTrace();
                            ExtensionScanner.this.getView().showWarningDialog("Error saving policy.");
                            return;
                        }
                    }
                }
            });
        }
        return this.menuItemPolicy;
    }

    public void hostProgress(String string, String string2, int n) {
        if (this.getView() != null) {
            this.getProgressDialog().updateHostProgress(string, string2, n);
        }
    }

    public void hostComplete(String string) {
        if (this.getView() != null) {
            this.getProgressDialog().removeHostProgress(string);
        }
    }

    public void hostNewScan(String string, HostProcess hostProcess) {
        if (this.getView() != null) {
            this.getProgressDialog().addHostProgress(string, hostProcess);
        }
    }

    public void alertFound(Alert alert) {
        try {
            this.writeAlertToDB(alert);
            this.addAlertToDisplay(alert);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addAlertToDisplay(Alert alert) {
        this.treeAlert.addPath(alert);
        if (this.getView() != null) {
            this.getAlertPanel().expandRoot();
        }
    }

    private ProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog((Frame)this.getView().getMainFrame(), false);
            this.progressDialog.setSize(500, 460);
        }
        return this.progressDialog;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    private JMenuItem getMenuItemScan() {
        if (this.menuItemScan == null) {
            this.menuItemScan = new JMenuItem();
            this.menuItemScan.setText("Scan");
            this.menuItemScan.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTree jTree = ExtensionScanner.this.getView().getSiteTreePanel().getTreeSite();
                    SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
                    if (siteNode == null) {
                        ExtensionScanner.this.getView().showWarningDialog("Please select a site/folder/URL in Sites panel.");
                        return;
                    }
                    ExtensionScanner.this.menuItemScan.setEnabled(false);
                    ExtensionScanner.this.menuItemScanAll.setEnabled(false);
                    ExtensionScanner.this.startScan(siteNode);
                }
            });
        }
        return this.menuItemScan;
    }

    AlertPanel getAlertPanel() {
        if (this.alertPanel == null) {
            this.alertPanel = new AlertPanel();
            this.alertPanel.setView(this.getView());
            this.alertPanel.setSize(345, 122);
            this.alertPanel.getTreeAlert().setModel(this.getTreeModel());
        }
        return this.alertPanel;
    }

    private DefaultTreeModel getTreeModel() {
        if (this.treeAlert == null) {
            this.treeAlert = new AlertTreeModel();
        }
        return this.treeAlert;
    }

    private void writeAlertToDB(Alert alert) throws HttpMalformedHeaderException, SQLException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        HistoryReference historyReference = new HistoryReference(this.getModel().getSession(), 3, alert.getMessage());
        RecordAlert recordAlert = tableAlert.write(this.recordScan.getScanId(), alert.getPluginId(), alert.getAlert(), alert.getRisk(), alert.getReliability(), alert.getDescription(), alert.getUri(), alert.getParam(), alert.getOtherInfo(), alert.getSolution(), alert.getReference(), historyReference.getHistoryId());
        alert.setAlertId(recordAlert.getAlertId());
    }

    public void sessionChanged(Session session) {
        AlertTreeModel alertTreeModel = (AlertTreeModel)this.getAlertPanel().getTreeAlert().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)alertTreeModel.getRoot();
        while (defaultMutableTreeNode.getChildCount() > 0) {
            alertTreeModel.removeNodeFromParent((MutableTreeNode)defaultMutableTreeNode.getChildAt(0));
        }
        try {
            this.refreshAlert(session);
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private void refreshAlert(Session session) throws SQLException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        Vector vector = tableAlert.getAlertListBySession(session.getSessionId());
        for (int i = 0; i < vector.size(); ++i) {
            int n = (Integer)vector.get(i);
            RecordAlert recordAlert = tableAlert.read(n);
            Alert alert = new Alert(recordAlert);
            this.addAlertToDisplay(alert);
        }
    }

    ManualRequestEditorDialog getManualRequestEditorDialog() {
        if (this.manualRequestEditorDialog == null) {
            this.manualRequestEditorDialog = new ManualRequestEditorDialog((Frame)this.getView().getMainFrame(), false, false, this);
            this.manualRequestEditorDialog.setTitle("Resend");
            this.manualRequestEditorDialog.setSize(500, 600);
        }
        return this.manualRequestEditorDialog;
    }

    private PopupMenuResend getPopupMenuResend() {
        if (this.popupMenuResend == null) {
            this.popupMenuResend = new PopupMenuResend();
            this.popupMenuResend.setExtension(this);
        }
        return this.popupMenuResend;
    }

    private OptionsScannerPanel getOptionsScannerPanel() {
        if (this.optionsScannerPanel == null) {
            this.optionsScannerPanel = new OptionsScannerPanel();
        }
        return this.optionsScannerPanel;
    }

    private ScannerParam getScannerParam() {
        if (this.scannerParam == null) {
            this.scannerParam = new ScannerParam();
        }
        return this.scannerParam;
    }

    public void execute(CommandLineArgument[] commandLineArgumentArray) {
        if (this.arguments[0].isEnabled()) {
            System.out.println("Scanner started...");
            this.startScan();
        } else {
            return;
        }
        while (!this.getScanner().isStop()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        System.out.println("Scanner completed.");
    }

    private CommandLineArgument[] getCommandLineArguments() {
        this.arguments[0] = new CommandLineArgument("-scan", 0, null, "", "-scan : Run vulnerability scan depending on previously saved policy.");
        return this.arguments;
    }

    private PopupMenuScanHistory getPopupMenuScanHistory() {
        if (this.popupMenuScanHistory == null) {
            this.popupMenuScanHistory = new PopupMenuScanHistory();
            this.popupMenuScanHistory.setExtension(this);
        }
        return this.popupMenuScanHistory;
    }
}

