//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _RTE_HDR_TYPE_H
#define _RTE_HDR_TYPE_H

#include "constants.h"
#include "packet.h"
#include "gpdlinetool.h"

namespace gpspoint2 {
using namespace std;
using namespace gpspoint2;


/// base class for route header
class Rte_Hdr_Type : GPDLineTool
{
   public:
      virtual ~Rte_Hdr_Type(){};
      Rte_Hdr_Type(void);
      /// initializes a route header
      Rte_Hdr_Type(const string &name, int number);

      /// output as string
      string os(void);
      /// output to stream
      void os(ostream);


      /// set the data by garmin-packet 
      virtual void set(Packet);


      /// make Packet
      virtual Packet makePacket(void);
   
      /// set the data by gpd-string
      void set(string);

      /// same as set
      void operator<<(string);

      /// 
      virtual void clear(void);

      /// return route name
      const string &getName() const { return name; }

      /// return route number
      const int getNumber() const { return number; }

   protected:
      string name;
      int number;

   private:
};

}
#endif
