package TDS::Replacer::Dictionary;
# $Id: Dictionary.pm,v 1.29 2000/12/16 07:17:24 tom Exp $
################################################################

=head1 NAME

TDS::Replacer::DIctionary - Ѵ饹

=head1 SYNOPSIS


=cut

use strict;
use vars qw(@ISA
	    $DictionaryLinkTemplate
	    $ReplaceTemplate $ReplaceTemplateUrlLinked);

use Exporter;
@ISA = qw(TDS::Replacer::Base); # TDS::Skelton);    # ¿ŷѾϤʤ

use ObjectTemplate;
use CGI::Tools;
use Template;
use JConv;

use TDS::Replacer::Base;
use TDS::Replacer::Url;
use TDS::Cache::DirInfo;
use TDS::System;
use TDS::Skelton;
use TDS::Cache;
use TDS::Mode;
use TDS::DirInfo;

# template
$DictionaryLinkTemplate = qq(<a href="%dictionary\#%encoded_term"><sup>*</sup></a>);
$ReplaceTemplateUrlLinked = qq(<a href="%url">%object</a>%link);
$ReplaceTemplate =  qq(<span class="replaced-word">%object</span>%link);

attributes (qw(replacer_url parser assoc));

=head1 MEMBER FUNCTIONS

=cut

sub initialize($)
{
    my $self = shift;

#    die "BUG: must be set replacer_url in Dictionary"
    $self->replacer_url(new TDS::Replacer::Url)
	unless ref $self->replacer_url;
    $self->datafile(GetDataDir() . "/dictionary.dat")
	unless $self->datafile;

    require TDS::Tdf::Parser;
    $self->parser(new TDS::Tdf::Parser);
    $self->assoc({});
    $self->SUPER::initialize;
}
################################################################

sub Read($)
{
    my $self = shift;

    open(F, $self->datafile) || return;
    sub conv;
    *conv = mkjconv($TDS::Collection::TdfJcode, $TDS::System::InternalJcode);

    my ($number, $cmd_number, $tab2_number);
    my @input;
    while(<F>){
	conv(\$_);
	push(@input, $_);

	if (/^WORD\s/ || /^PRONOUNCE/){
	    $cmd_number++;
	}
	if (/\t/ == 2){
	    $tab2_number++;
	}
	unless (/^$/ || /^\#/){
	    $number++;
	}
    }
    my $is_new_format;
    if ($cmd_number){           # WORD, PRONOUNCE ʹԤĤǤ⤢
	if ($tab2_number/$number < .8){
	    $is_new_format = 1;
	}
    } else {                    # ʤе
	$is_new_format = 0;
    }
    ################
    unless ($is_new_format){
	my @tmp = @input;
	@input = ();
	for (@tmp){
	    if (/^#/ || /^$/) {
		push(@input, $_);
	    } else {
		my ($word, $pronounce, $html) = split("\t");
		push(@input, ("WORD $word\n", "PRONOUNCE $pronounce\n", "$html\n"));
	    }
	}
    }
    for (@input){
	next if (/^$/ || /^\#/);
	$self->ReadLine($_);
    }
    close F;
    for (@{$self->parser->top->{content}}){
	$self->assoc->{$_->{ext_attrs}} = $_;
	$self->contents->{$_->{ext_attrs}} = {};  # why???
    }
}
sub ReadLine ($$)
{
    my ($self, $line) = @_;
    $self->parser->Parse($line);
}

sub RealReplace($$$)
{
    my ($self, $term, $object) = @_;

    my $encoded_term;
    my $anc;
    if ($anc = $self->assoc->{$term}->HasChild('ANCHORNAME')){
#	print %$anc;
	$encoded_term = join('', @{$anc->{content}});
    } else {
	$encoded_term = UrlEncode($term);
    }
    my $template;

    # dictionary link
    my $dictionary = (TDS::Mode::IsStatic()) ?
	'dictionary.html' : 'dictionary.cgi';
    my $params_link = {dictionary=>$dictionary,
		       encoded_term=>$encoded_term};
    my $link = Expand($DictionaryLinkTemplate, $params_link);

    # url link check
    my $tmp = $self->replacer_url->contents->{$term};
    my $url = $tmp->{replaced} if ref $tmp eq 'HASH';
    $template = ($url) ? $ReplaceTemplateUrlLinked : $ReplaceTemplate;
    my $params = {'link'=>$link,
		  'url'=>$url,
		  'object'=>$object};
    return Expand($template, $params);
}

1;



