#.rst:
# botan-config.cmake
# -----------
#
# Find the botan library.
#
# This CMake configuration file, installed as part of the Botan build,
# provides support for find_package(Botan).
#
# Required version(s) can be passed as usual:
# find_package(Botan 3.3.0 REQUIRED)
#
# COMPONENTS and OPTIONAL_COMPONENTS can be used to specify Botan
# modules that must or should be enabled in the Botan build:
# find_package(Botan 3.3.0 COMPONENTS rsa ecdsa)
#
# IMPORTED Targets
# ^^^^^^^^^^^^^^^^
#
# This module defines :prop_tgt:`IMPORTED` targets:
#
# ``Botan::Botan``
#   The botan shared library, if found.
# ``Botan::Botan-static``
#   The botan static library, if found.
#
# Result variables
# ^^^^^^^^^^^^^^^^
#
# This module defines the following variables:
#
# ::
#
#   Botan_FOUND          - true if the headers and library were found
#   Botan_VERSION        - library version that was found, if any
#

set(_Botan_supported_components
adler32
aead
aes
aes_crystals_xof
argon2
argon2fmt
aria
asio
asn1
auto_rng
base
base32
base58
base64
bcrypt
bcrypt_pbkdf
bigint
blake2
blake2mac
blake2s
block
blowfish
boost
bzip2
camellia
cascade
cast128
cbc
ccm
certstor_flatfile
certstor_sql
certstor_sqlite3
certstor_system
cfb
chacha
chacha20poly1305
chacha_rng
checksum
cmac
codec
comb4p
compat
compression
cpuid
crc24
crc32
cryptobox
cshake_xof
ctr
curve25519
des
dh
dilithium
dilithium_aes
dilithium_common
dl_algo
dl_group
dlies
dsa
dyn_load
eax
ec_group
ec_h2c
ecc_key
ecdh
ecdsa
ecgdsa
ecies
eckcdsa
ed25519
elgamal
eme_oaep
eme_pkcs1
eme_raw
emsa_pkcs1
emsa_pssr
emsa_raw
emsa_x931
entropy
fd_unix
ffi
filters
fpe_fe1
frodokem
frodokem_aes
frodokem_common
gcm
ghash
gmac
gost_28147
gost_3410
gost_3411
hash
hash_id
hex
hkdf
hmac
hmac_drbg
hotp
http_util
idea
iso9796
kdf
kdf1
kdf1_iso18033
kdf2
keccak
keccak_perm
keypair
kmac
kuznyechik
kyber
kyber_90s
kyber_common
lion
locking_allocator
lzma
mac
math
mce
md4
md5
mdx_hash
mem_pool
mgf1
misc
mode_pad
modes
mp
nist_keywrap
noekeon
numbertheory
ocb
ofb
par_hash
passhash
passhash9
pbes2
pbkdf
pbkdf2
pem
pgp_s2k
pk_pad
pkcs11
poly1305
poly_dbl
prf_tls
prf_x942
prov
psk_db
pubkey
raw_hash
rc4
rfc3394
rfc6979
rmd160
rng
roughtime
rsa
salsa20
scrypt
seed
serpent
sessions_sql
sessions_sqlite3
sha1
sha2_32
sha2_64
sha3
shacal2
shake
shake_cipher
shake_xof
siphash
siv
skein
sm2
sm3
sm4
socket
sodium
sp800_108
sp800_56a
sp800_56c
sphincsplus_common
sphincsplus_sha2
sphincsplus_shake
sqlite3
srp6
stateful_rng
stream
streebog
system_rng
thread_utils
threefish_512
tls
tls12
tls13
tls13_pqc
tls_cbc
trunc_hash
tss
twofish
utils
uuid
whirlpool
x509
x919_mac
xmss
xof
xts
zfec
zlib

)

unset(${CMAKE_FIND_PACKAGE_NAME}_FOUND)
unset(_Botan_missing_required_modules)

foreach(_comp IN LISTS ${CMAKE_FIND_PACKAGE_NAME}_FIND_COMPONENTS)
  if (NOT _comp IN_LIST _Botan_supported_components)
    set(${CMAKE_FIND_PACKAGE_NAME}_${_comp}_FOUND False)
    if(${CMAKE_FIND_PACKAGE_NAME}_FIND_REQUIRED_${_comp})
      list(APPEND _Botan_missing_required_modules ${_comp})
    endif()
  else()
    set(${CMAKE_FIND_PACKAGE_NAME}_${_comp}_FOUND True)
  endif()
endforeach()

if(_Botan_missing_required_modules)
  set(${CMAKE_FIND_PACKAGE_NAME}_FOUND False)
  list(JOIN _Botan_missing_required_modules ", " _missing_modules)
  set(${CMAKE_FIND_PACKAGE_NAME}_NOT_FOUND_MESSAGE "Unsupported module(s): ${_missing_modules}")
endif()

if(DEFINED ${CMAKE_FIND_PACKAGE_NAME}_FOUND AND NOT ${${CMAKE_FIND_PACKAGE_NAME}_FOUND})
  return()
endif()

# botan-config.cmake lives in "${_Botan_PREFIX}/lib/cmake/Botan-X": traverse up to $_Botan_PREFIX
set(_Botan_PREFIX "${CMAKE_CURRENT_LIST_DIR}")
get_filename_component(_Botan_PREFIX "${_Botan_PREFIX}" DIRECTORY)
get_filename_component(_Botan_PREFIX "${_Botan_PREFIX}" DIRECTORY)
get_filename_component(_Botan_PREFIX "${_Botan_PREFIX}" DIRECTORY)

if(NOT TARGET Botan::Botan-static)
  add_library(Botan::Botan-static STATIC IMPORTED)
  set_target_properties(Botan::Botan-static
    PROPERTIES
      IMPORTED_LOCATION                 "${_Botan_PREFIX}/lib/libbotan-3.a"
      INTERFACE_INCLUDE_DIRECTORIES     "${_Botan_PREFIX}/include/botan-3"
      IMPORTED_LINK_INTERFACE_LANGUAGES "CXX"
      INTERFACE_LINK_OPTIONS            "SHELL:-fstack-protector -m64 -mno-app-regs -pthread")
endif()

set(_Botan_implib "")

if(NOT TARGET Botan::Botan)
  if(NOT DEFINED _Botan_shared_lib)
    set(_Botan_shared_lib "${_Botan_PREFIX}/lib/libbotan-3.so.3")
  endif()

  add_library(Botan::Botan SHARED IMPORTED)
  set_target_properties(Botan::Botan
    PROPERTIES
      IMPORTED_LOCATION             "${_Botan_shared_lib}"
      IMPORTED_IMPLIB               "${_Botan_implib}"
      INTERFACE_INCLUDE_DIRECTORIES "${_Botan_PREFIX}/include/botan-3"
      INTERFACE_LINK_OPTIONS        "SHELL:-fstack-protector -m64 -mno-app-regs -pthread")
  set_property(TARGET Botan::Botan APPEND PROPERTY IMPORTED_CONFIGURATIONS NOCONFIG)
  set_target_properties(Botan::Botan
    PROPERTIES
      IMPORTED_LOCATION_NOCONFIG "${_Botan_PREFIX}/lib/libbotan-3.so.3"
      IMPORTED_SONAME_NOCONFIG   "libbotan-3.so.3"
      IMPORTED_IMPLIB_NOCONFIG   "${_Botan_implib}")
endif()

set(${CMAKE_FIND_PACKAGE_NAME}_FOUND True)
