/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] iv;
    private int rounds;
    private int version;
    private int wordSize;

    public byte[] getIV() {
        return this.iv;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getVersion() {
        return this.version;
    }

    public int getWordSize() {
        return this.wordSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        byte[] oiv = ((RC5ParameterSpec)o).getIV();
        if (this.iv != oiv) {
            if (this.iv == null || oiv == null) {
                return false;
            }
            if (this.iv.length != oiv.length) {
                return false;
            }
            int i = 0;
            while (i < this.iv.length) {
                if (this.iv[i] != oiv[i]) {
                    return false;
                }
                ++i;
            }
        }
        boolean bl = false;
        if (this.rounds == ((RC5ParameterSpec)o).getRounds() && this.version == ((RC5ParameterSpec)o).getVersion() && this.wordSize == ((RC5ParameterSpec)o).getWordSize()) {
            bl = true;
        }
        return bl;
    }

    public int hashCode() {
        int code = this.rounds + this.version + this.wordSize;
        if (this.iv != null) {
            int i = 0;
            while (i < this.iv.length) {
                code += this.iv[i];
                ++i;
            }
        }
        return code;
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize) {
        this.version = version;
        this.rounds = rounds;
        this.wordSize = wordSize;
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv) {
        this(version, rounds, wordSize, iv, 0);
    }

    public RC5ParameterSpec(int version, int rounds, int wordSize, byte[] iv, int off) {
        this(version, rounds, wordSize);
        int ivLength = 2 * (wordSize / 8);
        if (off < 0) {
            throw new IllegalArgumentException();
        }
        if (iv.length - off < ivLength) {
            throw new IllegalArgumentException("IV too short");
        }
        this.iv = new byte[ivLength];
        System.arraycopy(iv, off, this.iv, 0, ivLength);
    }
}

