package TDS::Power;
# $ID$
################################################################

use strict;
use vars qw(@ISA);

use CGI::Tools;
use Template;
use DateTime::Date;

use TDS;
use TDS::System;
use TDS::Skelton;
use TDS::Mode;
use TDS::Static;
use TDS::DirInfo;
use TDS::IdentInfo;

@ISA = qw(TDS::Skelton);

attributes qw();
################################################################

sub initialize($)
{
    my $self = shift;

    # set skelton
    $self->skelton(qq(<html><head>
		      <title><!--#macro cmd="TITLE" --></title></head>
		      <body><h1><!--#macro cmd="TITLE" --></h1>
		      <!--#macro cmd="CONTENT" --><hr>
		      <!--#macro cmd="STATICS" --><hr>
		      <a href="<!--#macro cmd="DIARY_URL" -->">back</a><br>
		      OPG for TDS
		      inspired by <a href="http://yar-3.net/d/">yar-3</a>
		      </body></html>));
    $self->SUPER::initialize;
}
sub SetMacros($)
{
    my $self = shift;
    
    # check requested tdf file and its file size
    my @files;

    my $status = $TDS::Status;
    my $direction;
    my $num;
    my $dt = new DateTime::Date;

    if ($status->mode eq 'MONTH'){
	$dt->Set($status->year, $status->month);
	$num = $dt->DaysMonth;
	$dt->day(1);
    } elsif ($status->mode eq 'PART'){
	$dt->Set($status->year, $status->month, $status->day_part);
	my ($start, $end) = $dt->part_span;
	$num = $end - $start + 1;
	$dt->day($start);
    } elsif ($status->mode eq 'DAY'){
	$dt->Set($status->year, $status->month, $status->day_part);
	$num = 1;
    } else {
	$dt->SetTime(time(), $TDS::System::TZ);
	$num = 30;
	$direction = "reverse";
    }
    for (1..$num){
	my $params = $dt->GetParams;
	$params->{dir} = GetDiaryDir();
	my $filename = Expand("%dir/%year/%0m/%0d.tdf", $params);
	push(@files, [$filename, $dt->year, $dt->month, $dt->day]);
	if ($direction eq 'reverse'){
	    $dt -= "1D";
	} else {
	    $dt += "1D";
	}
    }
    my $line;
    
    my $today = new DateTime::Date;
    $today->SetTime(time(), $TDS::System::TZ);

    my ($total, $num);
    ####
    for (@files){
	my $file = $_->[0];
	my $dt = new DateTime::Date;
	$dt->Set($_->[1], $_->[2], $_->[3]);
	next if $today < $dt;

	my $size = (stat($file))[7];
	my $template = qq(<a href="%href">%year/%0m/%0d</a>(%Week_holy) %size %bar\n);
	my $params = $dt->GetParams;
	$params->{size} = sprintf("%5d", $size);
	$params->{bar} = "*" x ($size/100);
	my $href_template;
	if (TDS::Mode::IsStatic()){
	    $href_template = "d%year%0m%part.%suffix\#%0d";
	    $params->{suffix} = $TDS::Static::HtmlSuffix;
	} else {
	    $href_template = "?%year%0m%0d\#%0d";
	}
	$params->{href} = Expand($href_template, $params);
	$line .= Expand($template, $params);
	
	$num++;
	$total += $size;
    }
    $self->SetMacro("CONTENT", "<pre>$line</pre>");
    $self->SetMacro("TITLE", sub {
	my $title = TDS::IdentInfo->Get('title');
	return "Ore Power Grade - $title";
    });
    
    $self->SetMacro("STATICS", sub {
	my $template = qq(<table border=1>
			  <tr><th>Total<td>%total
			  <tr><th>Average<td>%average
			  </table>);
	my $average = sprintf("%d", ($num) ? $total/$num : 0);
	my $params = {total=>$total,
		      average=>$average};
	return Expand($template, $params);
    });
    $self->SUPER::SetMacros;
}
1;

