/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.Alignable;
import com.jidesoft.swing.AlignmentSupport;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class JideLabel
extends JLabel
implements Alignable,
AlignmentSupport {
    private static final String uiClassID = "JideLabelUI";
    public static final String PROPERTY_CLOCKWISE = "clockwise";
    private boolean _clockwise = true;
    private int _orientation;

    public JideLabel() {
    }

    public JideLabel(String text) {
        super(text);
    }

    public JideLabel(Icon image, int horizontalAlignment) {
        super(image, horizontalAlignment);
    }

    public JideLabel(Icon image) {
        super(image);
    }

    public JideLabel(String text, int horizontalAlignment) {
        super(text, horizontalAlignment);
    }

    public JideLabel(String text, Icon icon, int horizontalAlignment) {
        super(text, icon, horizontalAlignment);
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(uiClassID) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public int getOrientation() {
        return this._orientation;
    }

    @Override
    public void setOrientation(int orientation) {
        int old = this._orientation;
        if (old != orientation) {
            this._orientation = orientation;
            this.firePropertyChange("orientation", old, orientation);
        }
    }

    @Override
    public boolean supportVerticalOrientation() {
        return true;
    }

    @Override
    public boolean supportHorizontalOrientation() {
        return true;
    }

    public boolean isClockwise() {
        return this._clockwise;
    }

    public void setClockwise(boolean clockwise) {
        boolean old = this._clockwise;
        if (clockwise != this._clockwise) {
            this._clockwise = clockwise;
            this.firePropertyChange(PROPERTY_CLOCKWISE, old, this._clockwise);
        }
    }
}

