/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.collections;

public class IntArrayList {
    private transient int[] elements;
    private int size;

    public IntArrayList() {
        this(100);
    }

    public IntArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        this.elements = new int[initialCapacity];
    }

    public IntArrayList(int[] elements) {
        this.elements = elements;
        this.size = elements.length;
    }

    public void add(int e) {
        if (this.size + 1 >= this.elements.length) {
            this.grow();
        }
        this.elements[this.size++] = e;
    }

    public void addAll(int[] args) {
        int[] newElements = new int[this.size + args.length];
        System.arraycopy(this.elements, 0, newElements, 0, this.size);
        System.arraycopy(args, 0, newElements, this.size, args.length);
        this.elements = newElements;
        this.size += args.length;
    }

    public void addAll(IntArrayList aList) {
        this.addAll(aList.toArray());
    }

    public int get(int idx) {
        return this.elements[idx];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.size = 0;
    }

    private void grow() {
        int oldCapacity = this.elements.length;
        int newCapacity = oldCapacity < 10000000 ? oldCapacity * 2 : oldCapacity * 3 / 2 + 1;
        int[] tmp = new int[newCapacity];
        System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
        this.elements = tmp;
    }

    public int[] toArray() {
        this.trimToSize();
        return this.elements;
    }

    private void trimToSize() {
        int oldCapacity = this.elements.length;
        if (this.size < oldCapacity) {
            int[] tmp = new int[this.size];
            System.arraycopy(this.elements, 0, tmp, 0, this.size);
            this.elements = tmp;
        }
    }

    public void set(int idx, int i) {
        while (idx >= this.elements.length) {
            this.grow();
        }
        this.elements[idx] = i;
        if (++idx > this.size) {
            this.size = idx;
        }
    }
}

