/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.base.exceptions;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.base.exceptions.TimeoutExceptionUnchecked;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.TimeoutException;

public class CheckedExceptionTunnel
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public CheckedExceptionTunnel(Exception checkedExceptionOrNull) {
        super(checkedExceptionOrNull);
        assert (!(checkedExceptionOrNull instanceof RuntimeException));
    }

    protected CheckedExceptionTunnel(String msg) {
        super(msg);
    }

    protected CheckedExceptionTunnel() {
    }

    @Override
    public String getMessage() {
        if (this.getCause() != null && this.getCause().getMessage() != null) {
            return this.getCause().getMessage();
        }
        return super.getMessage();
    }

    @Override
    public String toString() {
        if (this.getCause() != null) {
            return this.getCause().toString();
        }
        return super.toString();
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        if (this.getCause() != null) {
            this.getCause().printStackTrace(s);
        } else {
            super.printStackTrace(s);
        }
    }

    public void printFullStackTrace() {
        this.printFullStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFullStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.println(super.toString());
            StackTraceElement[] trace = this.getStackTrace();
            int i = 0;
            while (i < trace.length) {
                s.println("\tat " + trace[i]);
                ++i;
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                CheckedExceptionTunnel.printStackTraceAsCause(ourCause, s, trace);
            }
        }
    }

    private static void printStackTraceAsCause(Throwable cause, PrintStream s, StackTraceElement[] causedTrace) {
        Throwable ourCauseesCause;
        StackTraceElement[] trace = cause.getStackTrace();
        int m = trace.length - 1;
        int n = causedTrace.length - 1;
        while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
            --m;
            --n;
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + cause);
        int i = 0;
        while (i <= m) {
            s.println("\tat " + trace[i]);
            ++i;
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCauseesCause = cause.getCause()) != null) {
            CheckedExceptionTunnel.printStackTraceAsCause(ourCauseesCause, s, trace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printFullStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.println(super.toString());
            StackTraceElement[] trace = this.getStackTrace();
            int i = 0;
            while (i < trace.length) {
                s.println("\tat " + trace[i]);
                ++i;
            }
            Throwable ourCause = this.getCause();
            if (ourCause != null) {
                CheckedExceptionTunnel.printStackTraceAsCause(ourCause, s, trace);
            }
        }
    }

    private static void printStackTraceAsCause(Throwable cause, PrintWriter s, StackTraceElement[] causedTrace) {
        Throwable ourCauseesCause;
        StackTraceElement[] trace = cause.getStackTrace();
        int m = trace.length - 1;
        int n = causedTrace.length - 1;
        while (m >= 0 && n >= 0 && trace[m].equals(causedTrace[n])) {
            --m;
            --n;
        }
        int framesInCommon = trace.length - 1 - m;
        s.println("Caused by: " + cause);
        int i = 0;
        while (i <= m) {
            s.println("\tat " + trace[i]);
            ++i;
        }
        if (framesInCommon != 0) {
            s.println("\t... " + framesInCommon + " more");
        }
        if ((ourCauseesCause = cause.getCause()) != null) {
            CheckedExceptionTunnel.printStackTraceAsCause(ourCauseesCause, s, trace);
        }
    }

    public static final RuntimeException wrapIfNecessary(Throwable throwable) throws Error {
        if (throwable instanceof Error) {
            if (throwable instanceof ThreadDeath) {
                return new InterruptedExceptionUnchecked();
            }
            throw (Error)throwable;
        }
        return CheckedExceptionTunnel.wrapIfNecessary((Exception)throwable);
    }

    public static final RuntimeException wrapIfNecessary(Exception exception) {
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (exception instanceof IOException) {
            return new IOExceptionUnchecked((IOException)exception);
        }
        if (exception instanceof InterruptedException) {
            return new InterruptedExceptionUnchecked((InterruptedException)exception);
        }
        if (exception instanceof TimeoutException) {
            return new TimeoutExceptionUnchecked((TimeoutException)exception);
        }
        return new CheckedExceptionTunnel(exception);
    }

    public static final Exception unwrapIfNecessary(Exception exception) {
        Exception causeOrNull;
        assert (exception != null) : "Exception not specified.";
        if (exception instanceof CheckedExceptionTunnel && (causeOrNull = (Exception)exception.getCause()) != null) {
            return causeOrNull;
        }
        return exception;
    }

    public static final Throwable unwrapIfNecessary(Throwable throwable) {
        assert (throwable != null) : "Exception not specified.";
        if (throwable instanceof Error) {
            return throwable;
        }
        return CheckedExceptionTunnel.unwrapIfNecessary((Exception)throwable);
    }
}

