require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_NFS_NFS_H_)) {
    eval 'sub _NFS_NFS_H_ () {1;}' unless defined(&_NFS_NFS_H_);
    if(defined(&_KERNEL)) {
	require 'sys/condvar.ph';
	require 'sys/fstypes.ph';
	require 'sys/mbuf.ph';
	require 'sys/mutex.ph';
	require 'sys/rbtree.ph';
    }
    require 'nfs/rpcv2.ph';
    eval 'sub NFS_MAXIOVEC () {34;}' unless defined(&NFS_MAXIOVEC);
    eval 'sub NFS_TICKINTVL () {5;}' unless defined(&NFS_TICKINTVL);
    eval 'sub NFS_HZ () {( &hz /  &nfs_ticks);}' unless defined(&NFS_HZ);
    eval 'sub NFS_TIMEO () {(3*  &NFS_HZ);}' unless defined(&NFS_TIMEO);
    eval 'sub NFS_MINTIMEO () {(1*  &NFS_HZ);}' unless defined(&NFS_MINTIMEO);
    eval 'sub NFS_MAXTIMEO () {(60*  &NFS_HZ);}' unless defined(&NFS_MAXTIMEO);
    eval 'sub NFS_MINIDEMTIMEO () {(5*  &NFS_HZ);}' unless defined(&NFS_MINIDEMTIMEO);
    eval 'sub NFS_MAXREXMIT () {100;}' unless defined(&NFS_MAXREXMIT);
    eval 'sub NFS_MAXWINDOW () {1024;}' unless defined(&NFS_MAXWINDOW);
    eval 'sub NFS_RETRANS () {10;}' unless defined(&NFS_RETRANS);
    eval 'sub NFS_MAXGRPS () {16;}' unless defined(&NFS_MAXGRPS);
    unless(defined(&NFS_MINATTRTIMO)) {
	eval 'sub NFS_MINATTRTIMO () {5;}' unless defined(&NFS_MINATTRTIMO);
    }
    unless(defined(&NFS_MAXATTRTIMO)) {
	eval 'sub NFS_MAXATTRTIMO () {60;}' unless defined(&NFS_MAXATTRTIMO);
    }
    eval 'sub NFS_TRYLATERDEL () {1;}' unless defined(&NFS_TRYLATERDEL);
    eval 'sub NFS_TRYLATERDELMAX () {(1*60);}' unless defined(&NFS_TRYLATERDELMAX);
    eval 'sub NFS_TRYLATERDELMUL () {2;}' unless defined(&NFS_TRYLATERDELMUL);
    eval 'sub NFS_CWNDSCALE () {256;}' unless defined(&NFS_CWNDSCALE);
    eval 'sub NFS_MAXCWND () {( &NFS_CWNDSCALE * 32);}' unless defined(&NFS_MAXCWND);
    unless(defined(&NFS_WSIZE)) {
	eval 'sub NFS_WSIZE () {8192;}' unless defined(&NFS_WSIZE);
    }
    unless(defined(&NFS_RSIZE)) {
	eval 'sub NFS_RSIZE () {8192;}' unless defined(&NFS_RSIZE);
    }
    unless(defined(&NFS_READDIRSIZE)) {
	eval 'sub NFS_READDIRSIZE () {8192;}' unless defined(&NFS_READDIRSIZE);
    }
    unless(defined(&NFS_MAXASYNCDAEMON)) {
	eval 'sub NFS_MAXASYNCDAEMON () {128;}' unless defined(&NFS_MAXASYNCDAEMON);
    }
    unless(defined(&NFS_MAXRAHEAD)) {
	eval 'sub NFS_MAXRAHEAD () {32;}' unless defined(&NFS_MAXRAHEAD);
    }
    eval 'sub NFS_DEFRAHEAD () {2;}' unless defined(&NFS_DEFRAHEAD);
    eval 'sub NFS_MAXUIDHASH () {64;}' unless defined(&NFS_MAXUIDHASH);
    eval 'sub NFS_DEFDEADTHRESH () { &NFS_NEVERDEAD;}' unless defined(&NFS_DEFDEADTHRESH);
    eval 'sub NFS_NEVERDEAD () {9;}' unless defined(&NFS_NEVERDEAD);
    if(defined(&_KERNEL)) {
	unless(defined(&NFS_DEFAULT_NIOTHREADS)) {
	    eval 'sub NFS_DEFAULT_NIOTHREADS () {4;}' unless defined(&NFS_DEFAULT_NIOTHREADS);
	}
    }
    eval 'sub NFS_MAXGATHERDELAY () {100;}' unless defined(&NFS_MAXGATHERDELAY);
    unless(defined(&NFS_GATHERDELAY)) {
	eval 'sub NFS_GATHERDELAY () {10;}' unless defined(&NFS_GATHERDELAY);
    }
    eval 'sub NFS_DIRBLKSIZ () {8192;}' unless defined(&NFS_DIRBLKSIZ);
    eval 'sub NFS_DIRFRAGSIZ () {512;}' unless defined(&NFS_DIRFRAGSIZ);
    eval 'sub NFS_MAXDIRCACHE () {( &NFS_DIRBLKSIZ / 14);}' unless defined(&NFS_MAXDIRCACHE);
    eval 'sub NFS_CMPFH {
        my($n, $f, $s) = @_;
	    eval q((($n)-> &n_fhsize == ($s)  && ! &memcmp(( &void *)($n)-> &n_fhp, ( &void *)($f), ($s))));
    }' unless defined(&NFS_CMPFH);
    if(defined(&NFS_V2_ONLY)) {
	eval 'sub NFS_ISV3 {
	    my($v) = @_;
    	    eval q((0));
	}' unless defined(&NFS_ISV3);
    } else {
	eval 'sub NFS_ISV3 {
	    my($v) = @_;
    	    eval q(( &VFSTONFS(($v)-> &v_mount)-> &nm_flag &  &NFSMNT_NFSV3));
	}' unless defined(&NFS_ISV3);
    }
    eval 'sub NFS_SRVMAXDATA {
        my($n) = @_;
	    eval q(((($n)-> &nd_flag &  &ND_NFSV3) ? ((($n)-> &nd_nam2) ?  &NFS_MAXDGRAMDATA :  &NFS_MAXDATA) :  &NFS_V2MAXDATA));
    }' unless defined(&NFS_SRVMAXDATA);
    eval 'sub PG_NEEDCOMMIT () { &PG_PAGER1;}' unless defined(&PG_NEEDCOMMIT);
    unless(defined(&IO_METASYNC)) {
	eval 'sub IO_METASYNC () {0;}' unless defined(&IO_METASYNC);
    }
    eval 'sub NFSSTATS_NPROCS () {26;}' unless defined(&NFSSTATS_NPROCS);
    eval 'sub NFSSVC_BIOD () {0x2;}' unless defined(&NFSSVC_BIOD);
    eval 'sub NFSSVC_NFSD () {0x4;}' unless defined(&NFSSVC_NFSD);
    eval 'sub NFSSVC_ADDSOCK () {0x8;}' unless defined(&NFSSVC_ADDSOCK);
    eval 'sub NFSSVC_AUTHIN () {0x10;}' unless defined(&NFSSVC_AUTHIN);
    eval 'sub NFSSVC_GOTAUTH () {0x40;}' unless defined(&NFSSVC_GOTAUTH);
    eval 'sub NFSSVC_AUTHINFAIL () {0x80;}' unless defined(&NFSSVC_AUTHINFAIL);
    eval 'sub NFSSVC_MNTD () {0x100;}' unless defined(&NFSSVC_MNTD);
    eval 'sub NFSSVC_SETEXPORTSLIST () {0x200;}' unless defined(&NFSSVC_SETEXPORTSLIST);
    eval 'sub NFSSVC_REPLACEEXPORTSLIST () {0x400;}' unless defined(&NFSSVC_REPLACEEXPORTSLIST);
    eval 'sub NFS_NFSSTATS () {1;}' unless defined(&NFS_NFSSTATS);
    eval 'sub NFS_IOTHREADS () {2;}' unless defined(&NFS_IOTHREADS);
    if(defined(&_KERNEL)) {
	eval 'sub NFSIGNORE_SOERROR {
	    my($s, $e) = @_;
    	    eval q((($e) !=  &EINTR  && ($e) !=  &ERESTART  && ($e) !=  &EWOULDBLOCK  && (($s) &  &PR_CONNREQUIRED) == 0));
	}' unless defined(&NFSIGNORE_SOERROR);
	eval 'sub R_TIMING () {0x1;}' unless defined(&R_TIMING);
	eval 'sub R_SENT () {0x2;}' unless defined(&R_SENT);
	eval 'sub R_SOFTTERM () {0x4;}' unless defined(&R_SOFTTERM);
	eval 'sub R_INTR () {0x8;}' unless defined(&R_INTR);
	eval 'sub R_SOCKERR () {0x10;}' unless defined(&R_SOCKERR);
	eval 'sub R_TPRINTFMSG () {0x20;}' unless defined(&R_TPRINTFMSG);
	eval 'sub R_MUSTRESEND () {0x40;}' unless defined(&R_MUSTRESEND);
	eval 'sub R_REXMITTED () {0x100;}' unless defined(&R_REXMITTED);
	unless(defined(&NFS_UIDHASHSIZ)) {
	    eval 'sub NFS_UIDHASHSIZ () {29;}' unless defined(&NFS_UIDHASHSIZ);
	}
	eval 'sub NUIDHASH {
	    my($sock, $uid) = @_;
    	    eval q((($sock)-> $ns_uidhashtbl[($uid) %  &NFS_UIDHASHSIZ]));
	}' unless defined(&NUIDHASH);
	unless(defined(&NFS_WDELAYHASHSIZ)) {
	    eval 'sub NFS_WDELAYHASHSIZ () {16;}' unless defined(&NFS_WDELAYHASHSIZ);
	}
	unless(defined(&NFS_MUIDHASHSIZ)) {
	    eval 'sub NFS_MUIDHASHSIZ () {63;}' unless defined(&NFS_MUIDHASHSIZ);
	}
	eval 'sub NMUIDHASH {
	    my($nmp, $uid) = @_;
    	    eval q((($nmp)-> $nm_uidhashtbl[($uid) %  &NFS_MUIDHASHSIZ]));
	}' unless defined(&NMUIDHASH);
	unless(defined(&NFS_DIRHASHSIZ)) {
	    eval 'sub NFS_DIRHASHSIZ () {64;}' unless defined(&NFS_DIRHASHSIZ);
	}
	eval 'sub NFSDIRHASH {
	    my($np, $off) = @_;
    	    eval q(( ($np->{n_dircache[(nfs_dirhash((off)) & nfsdirhashmask)]})));
	}' unless defined(&NFSDIRHASH);
	eval 'sub NFS_STASHCOOKIE {
	    my($dp,$off) = @_;
    	    eval q(*(( &off_t *)(($dp) + ($dp)-> &d_reclen - $sizeof{ &off_t})) = $off);
	}' unless defined(&NFS_STASHCOOKIE);
	eval 'sub NFS_GETCOOKIE {
	    my($dp) = @_;
    	    eval q((*(( &off_t *)(($dp) + ($dp)-> &d_reclen - $sizeof{ &off_t}))));
	}' unless defined(&NFS_GETCOOKIE);
	eval 'sub NFS_STASHCOOKIE32 {
	    my($dp, $val) = @_;
    	    eval q(*(( &u_int32_t *)(($dp) + ($dp)-> &d_reclen - $sizeof{ &off_t} - $sizeof{\'int\'})) = $val);
	}' unless defined(&NFS_STASHCOOKIE32);
	eval 'sub NFS_GETCOOKIE32 {
	    my($dp) = @_;
    	    eval q((*(( &u_int32_t *)(($dp) + ($dp)-> &d_reclen - $sizeof{ &off_t} - $sizeof{\'int\'}))));
	}' unless defined(&NFS_GETCOOKIE32);
	eval 'sub NFSBIO_CACHECOOKIES () {0x1;}' unless defined(&NFSBIO_CACHECOOKIES);
	eval 'sub nu_inetaddr () { ($nu_haddr->{had_inetaddr});}' unless defined(&nu_inetaddr);
	eval 'sub nu_nam () { ($nu_haddr->{had_nam});}' unless defined(&nu_nam);
	eval 'sub NU_INETADDR () {0x1;}' unless defined(&NU_INETADDR);
	eval 'sub NU_NAM () {0x2;}' unless defined(&NU_NAM);
	eval 'sub NU_NETFAM {
	    my($u) = @_;
    	    eval q(((($u)-> &nu_flag &  &NU_INETADDR) ?  &AF_INET :  &AF_INET6));
	}' unless defined(&NU_NETFAM);
	eval 'sub SLP_VALID () {0x1;}' unless defined(&SLP_VALID);
	eval 'sub SLP_BUSY () {0x10;}' unless defined(&SLP_BUSY);
	eval 'sub SLP_SENDING () {0x80;}' unless defined(&SLP_SENDING);
	eval 'sub SLP_A_NEEDQ () {0x1;}' unless defined(&SLP_A_NEEDQ);
	eval 'sub SLP_A_DISCONN () {0x4;}' unless defined(&SLP_A_DISCONN);
	eval 'sub SLP_G_DOREC () {0x2;}' unless defined(&SLP_G_DOREC);
	eval 'sub SLP_S_LASTFRAG () {0x40;}' unless defined(&SLP_S_LASTFRAG);
	eval 'sub SLP_INIT () {0x1;}' unless defined(&SLP_INIT);
	eval 'sub NFSD_NEEDAUTH () {0x4;}' unless defined(&NFSD_NEEDAUTH);
	eval 'sub NFSD_AUTHFAIL () {0x8;}' unless defined(&NFSD_AUTHFAIL);
	eval 'sub NFSD_MAXFHSIZE () {64;}' unless defined(&NFSD_MAXFHSIZE);
	eval 'sub NFSRVFH_SIZE {
	    my($nsfh) = @_;
    	    eval q((($nsfh)-> &nsfh_size));
	}' unless defined(&NFSRVFH_SIZE);
	eval 'sub NFSRVFH_DATA {
	    my($nsfh) = @_;
    	    eval q((($nsfh)-> ($nsfh_u->{u_opaque})));
	}' unless defined(&NFSRVFH_DATA);
	eval 'sub NFSRVFH_FHANDLE {
	    my($nsfh) = @_;
    	    eval q((($nsfh)-> ($nsfh_u->{u_fh})));
	}' unless defined(&NFSRVFH_FHANDLE);
	eval 'sub ND_READ () {0x1;}' unless defined(&ND_READ);
	eval 'sub ND_WRITE () {0x2;}' unless defined(&ND_WRITE);
	eval 'sub ND_CHECK () {0x4;}' unless defined(&ND_CHECK);
	eval 'sub ND_LEASE () {( &ND_READ |  &ND_WRITE |  &ND_CHECK);}' unless defined(&ND_LEASE);
	eval 'sub ND_NFSV3 () {0x8;}' unless defined(&ND_NFSV3);
	eval 'sub ND_KERBNICK () {0x20;}' unless defined(&ND_KERBNICK);
	eval 'sub ND_KERBFULL () {0x40;}' unless defined(&ND_KERBFULL);
	eval 'sub ND_KERBAUTH () {( &ND_KERBNICK |  &ND_KERBFULL);}' unless defined(&ND_KERBAUTH);
	eval 'sub NFSD_CHECKSLP () {0x1;}' unless defined(&NFSD_CHECKSLP);
	eval 'sub NFSW_CONTIG {
	    my($o, $n) = @_;
    	    eval q((($o)-> &nd_eoff >= ($n)-> &nd_off  && ! &memcmp(( &void *)($o)-> &nd_fh, ( &void *)($n)-> &nd_fh,  &NFSX_V3FH)));
	}' unless defined(&NFSW_CONTIG);
	eval 'sub WEBNFS_ESC_CHAR () {ord(\'%\');}' unless defined(&WEBNFS_ESC_CHAR);
	eval 'sub WEBNFS_SPECCHAR_START () {0x80;}' unless defined(&WEBNFS_SPECCHAR_START);
	eval 'sub WEBNFS_NATIVE_CHAR () {0x80;}' unless defined(&WEBNFS_NATIVE_CHAR);
	eval 'sub HEXTOC {
	    my($c) = @_;
    	    eval q((($c) >= ord(\'a\' ? ((c) - (\'a\' - 10)) : 	    ((c) >= \'A\' ? ((c) - (\'A\' - 10)) : ((c) - \'0\')))));
	}' unless defined(&HEXTOC);
	eval 'sub HEXSTRTOI {
	    my($p) = @_;
    	    eval q((( &HEXTOC($p->[0]) << 4) +  &HEXTOC($p->[1])));
	}' unless defined(&HEXSTRTOI);
    }
}
1;
